package com.bcxin.signature;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.core.env.Environment;

@SpringBootApplication(exclude={DataSourceAutoConfiguration.class})
@ServletComponentScan
public class Application extends SpringBootServletInitializer {

	/**
	 * 不使用内嵌tomcat的配置
	 */
	@Override
	protected SpringApplicationBuilder configure( SpringApplicationBuilder application) {
		return application.sources(Application.class);
	}

	private static final Logger log = LoggerFactory.getLogger(Application.class);

	public static void main(String[] args) {
		SpringApplication app = new SpringApplication(Application.class);
		Environment env = app.run(args).getEnvironment();
		log.info("\n----------------------------------------------------------\n\t" +
						"Application '{}' is running! Access URLs:\n\t" +
						"Local: \t\thttp://localhost:{}\n\t" +
						"----------------------------------------------------------",
				env.getProperty("spring.application.name"),
				env.getProperty("server.port"));
		String[] activeProfiles = env.getActiveProfiles();
		System.err.println("启动的配置文件为："+ JSON.toJSONString(activeProfiles));
		System.err.println("sample started. http://localhost:8888");
		System.err.println("sample started. http://localhost:8888/sys/main/index");
	}

}
