package com.bcxin.backend.domain.system.repositories;

import com.bcxin.backend.domain.system.entities.UserDTO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.Collection;

public interface UserRepository extends JpaRepository<UserDTO, String> {
    @Query("select u from com.bcxin.backend.domain.system.entities.UserDTO u where u.field27='未同步分发'")
    Page<UserDTO> getPendingSyncs(PageRequest pageRequest);

    @Query("select u from UserDTO u where u.id in ?1")
    Collection<UserDTO> findAllByIdWithin(Collection<String> ids);
}
