package com.bcxin.backend.domain.syncs.dtos;

import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.util.Map;

@Data
public class SyncDataResponse {
    private String requestUrl;
    private Map<String, Object> requestHeaders;
    private String requestBody;
    private String processedMsg;
    private String originalRequestBody;

    private int status;
    private String body;

    public static SyncDataResponse create(String requestUrl, Map<String, Object> requestHeaders, String requestBody) {
        SyncDataResponse response = new SyncDataResponse();
        response.setRequestUrl(requestUrl);
        response.setRequestBody(requestBody);
        response.setRequestHeaders(requestHeaders);

        return response;
    }

    public void assign(int status, String body) {
        this.setStatus(status);
        this.setBody(body);
    }

    public void assignProcessedMsg(String processedMsg) {
        this.setProcessedMsg(processedMsg);
    }

    public void assignOriginalRequestBody(String requestBody) {
        this.setOriginalRequestBody(requestBody);
    }

    @Getter
    @Setter(AccessLevel.PRIVATE)
    public static class ProcessMsg {
        private String message;
        private String body;

        public static ProcessMsg create(String message,String body) {
            ProcessMsg msg = new ProcessMsg();
            msg.setBody(body);
            msg.setMessage(message);

            return msg;
        }
    }
}
