package com.bcxin.backend.domain.repositories;

import com.bcxin.backend.domain.models.SignatureQueuesDocument;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;


public interface SignatureQueuesDocumentRepository extends JpaRepository<SignatureQueuesDocument, String> {
    @Query("select s from SignatureQueuesDocument s where s.status=?1 order by s.created desc")
    Page<SignatureQueuesDocument> pageQueues(int status, PageRequest pageRequest);

    @Query("select s from SignatureQueuesDocument s where s.status=2 and s.file_url='null' order by s.created desc")
    List<SignatureQueuesDocument> queuesFileNull();

    @Query("select s from SignatureQueuesDocument s where s.status=?1 and s.business_type in ('15','25','45','55','65') and (s.jt_code is null or s.jt_code='') order by s.created desc")
    Page<SignatureQueuesDocument> pageQueuesBy5Minute(int status, PageRequest pageRequest);

    @Query("select s from SignatureQueuesDocument s where s.status=?1 and s.business_type in ('15','25','45','55','65') and s.jt_code='废止' order by s.created desc")
    Page<SignatureQueuesDocument> pageQueuesByCodeFZ(int status, PageRequest pageRequest);

    @Query("select s from SignatureQueuesDocument s where s.status in (?1) and s.lastmodified >= ?2 order by s.created desc")
    Page<SignatureQueuesDocument> pageQueuesByLastmodified(List<Integer> statuses, Date lastmodified, PageRequest pageRequest);

    @Query("select s.business_id from SignatureQueuesDocument s where s.id=?1")
    String getBuId(Long id);

    @Query("select s from SignatureQueuesDocument s where s.business_id=?1 and s.business_type=?2")
    SignatureQueuesDocument getSignatureQueuesDocument(String business_id, String business_type);

    @Modifying
    @Transactional
    @Query("UPDATE SignatureQueuesDocument s SET s.status=?1,s.lastmodified=?2,s.processed_result=?3 WHERE s.id=?4")
    void updateSignatureQueuesDocument(int status, Date lastTime, String result, Long id);

    @Modifying
    @Transactional
    @Query("UPDATE SignatureQueuesDocument s SET s.status=?1,s.lastmodified=?2,s.processed_result=?3,s.jt_code=?4 WHERE s.id=?5")
    void updateSignatureQueuesDocument(int status, Date lastTime, String result, String jtCode, Long id);

    @Modifying
    @Transactional
    @Query("UPDATE SignatureQueuesDocument s SET s.jt_code=?1,s.lastmodified=?2,s.processed_result=?3 WHERE s.id=?4")
    void updateJtCode(String jtCode, Date lastTime, String result, Long id);

    @Modifying
    @Transactional
    @Query("UPDATE SignatureQueuesDocument s SET s.status=?1,s.lastmodified=?2,s.processed_result=?3 WHERE s.id in (?4)")
    void updateSignatureQueuesDocuments(int status, Date lastTime, String result, List<Long> ids);

    @Modifying
    @Transactional
    @Query("UPDATE SignatureQueuesDocument s SET s.status=?1,s.lastmodified=?2,s.file_url=?3,s.jt_code=?4 WHERE s.id=?5")
    void resetDocumentPath(int status, Date lastTime, String file_url, String jt_code, Long id);

    @Modifying
    @Transactional
    @Query("DELETE FROM SignatureQueuesDocument s where s.status=4 and s.lastmodified<?1")
    void deleteNonDocumentSignatureQueues(Date lastmodified);
}
