package com.bcxin.backend.domain.models;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import javax.swing.*;

@Data
public class DomainSuperviseDTO{
    private String domainId;
    private SuperviseDTO supervise;

    public String getIdentityValue() {
        return String.format("domainId=%s;systemURLNw=%s;systemUrl=%s;systemAdmin=%s;targetServiceUrl=%s",
                domainId, supervise.getTargetApp(), supervise.getSrcApp(), supervise.getSystemAdmin(), supervise.getTargetServiceUrl());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().isAssignableFrom(DomainSuperviseDTO.class)) {
            return false;
        }

        DomainSuperviseDTO o = (DomainSuperviseDTO) obj;
        int result = this.getDomainId().compareTo(o.getDomainId());
        if (result != 0) {
            return false;
        }

        if (this.getIdentityValue().compareTo(o.getIdentityValue()) != 0) {
            return false;
        }

        return true;
    }

    public static DomainSuperviseDTO create(String domainId,SuperviseDTO supervise) {
        DomainSuperviseDTO domainSupervise = new DomainSuperviseDTO();
        domainSupervise.setDomainId(domainId);
        domainSupervise.setSupervise(supervise);

        return domainSupervise;
    }
}
