package com.bcxin.backend.domain.enums;

public enum LogStatus implements EnumValue {
    Initialize(0, "初始化"),
    Done(1, "完成"),
    Processing(2, "处理中"),
    Error(3, "异常"),
    Retry(4, "重试中"),
    PartialDone(5, "部分完成");

    private final int value;
    private final String desc;

    LogStatus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }
}
