package com.bcxin.backend.domain.approval.entities.dest;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;


@Data
@Entity
@Table(name = "bjga_service_statistic_ods")
public class BjGaServiceStatisticOdsEntity {
    @Id
    @Column(name = "projectno")
    private String projectNo;

    @Column(name = "task_name")
    private String taskName;

    @Column(name = "task_type")
    private int taskType = 1;

    @Column(name = "applyer_name")
    private String applyerName;

    @Column(name = "applyer_code")
    private String applyerCode;

    @Column(name = "orgname")
    private String orgName;

    @Column(name = "police_station")
    private String policeStation;

    @Column(name = "transaction_state")
    private int transactionState;

    @Column(name = "apply_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyDate;
}
