package com.baichuanxin.openrestapi.dtos;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baichuanxin.openrestapi.common.OnlineTaskConstant;
import com.baichuanxin.openrestapi.common.utils.DateUtil;
import com.baichuanxin.openrestapi.common.utils.OnlineTaskUtil;
import com.baichuanxin.openrestapi.entity.CrossRegionalFiling;
import com.baichuanxin.openrestapi.entity.Notice;
import lombok.Data;

import java.util.Date;
import java.util.List;

/***
 *@Author duxiangyun
 *@Description 跨区域经营备案 业务数据解析
 *@Date 2024/8/30
 */
@Data
public class CrossRegionalFilingDto {

    /**
     * 1、1、选择办事区域
     */
    //所属监管机构
    private String item_officePoliceAddress;

    /**
     * 2、填写公司信息
     */
    //公司名称
    private String item_companyName;
    //公司地址
    private  String item_address;
    //统一社会信用代码
    private String item_creditCode;
    //联系电话
    private String item_phone;
    //总公司保安服务许可证号
    private String item_licenceNum;
    //公司类型
    private String  item_company_type;
    //经营范围
    private List<String>  item_businessScope;
    //办公地址
    private String item_work_address;
    /**
     * 3、填写法人信息
     */
    //姓名
    private String item_legalName;
    //手机号码
    private String item_legalPhone;
    //证件类型
    private String item_legalType;
    //证件号码
    private String item_legalCardnumber;

    /**
     * 4、填写拟开展保安服务项目信息
     */

    //拟跨区域经营的保安服务项目
    private String item_managerproject;
    //项目地址
    private String item_sonAddress;
    //合同期限
    private Date item_contract_end_date;
    //合同金额
    private String item_contract_amount;

    //保安员数  在保安员信息里


    /**
     * 4.1、保安员信息
     */
    //保安员信息
    private List<SecurityManDto> bayxx;

    /**
     * 5、填写项目负责人信息
     */
    //  5、填写项目负责人信息
    //姓名
    private String item_chargeName;
    //手机号码
    private String item_chargePhone;
    //职务
    private String item_chargePost;
    //证件号码
    private String item_chargeCardnumber;
    //证件类型
    private String  mother_name_of_ID_certificate;
    //性别
    private String item_sex_2;
    //年龄
    private String item_charge_age;
    //籍贯
    private String item_charge_household;
    //民族
    private String item_nation_3;
    //现住址
    private String item_charge_address;
    //工作简历
    private String item_job_resume;

    /**
     * 6、经办人信息
     */
    //姓名
    private String  item_applicant_name;
    //联系电话
    private String item_applicant_phone;

    /**
     * 承诺上述填报信息真实有效
     */
    //承诺上述填报信息真实有效
    private String item_premit;
//    /**
//     * 7、上传电子版材料（模版下载）
//     */
//    private List<AttachDto> attachList;

    public CrossRegionalFiling convert(Notice notice){
        CrossRegionalFiling crossRegionalFiling  =new CrossRegionalFiling();
        Date now  = new Date();
        //审核状态数据
        crossRegionalFiling.setItemAuditStatus("3");
        //办件数据
        crossRegionalFiling.setTaskId(notice.getTaskId());
        //表单数据
        crossRegionalFiling.setId(StrUtil.join("--",notice.getTaskId(), OnlineTaskConstant.CROSS_REGION));
        crossRegionalFiling.setCreated(now);
        crossRegionalFiling.setLastmodified(now);
        crossRegionalFiling.setFormname("");
        crossRegionalFiling.setFormid(OnlineTaskConstant.CROSS_REGION);
        crossRegionalFiling.setIstmp(true);
        crossRegionalFiling.setApplicationid("__JvOHkqjhV41mUo4ITRv");
        crossRegionalFiling.setDomainid("__UDa4uPMdcOYgP7HETaf");
        crossRegionalFiling.setItemRegion("湖南省");
        crossRegionalFiling.setIsdelivery("0");

        //业务数据
        //所属办事区域
        crossRegionalFiling.setItemOfficePoliceAddress(this.getItem_officePoliceAddress());
        //填写公司信息
        crossRegionalFiling.setItemCompanyName(this.getItem_companyName());
        //格式化公司地址
        AddressDto addressDto = JSON.parseObject(this.getItem_address(), AddressDto.class);
        crossRegionalFiling.setItemAddress(addressDto.convert());
        crossRegionalFiling.setItemCreditCode(this.getItem_creditCode());
        crossRegionalFiling.setItemPhone(this.getItem_phone());
        crossRegionalFiling.setItemLicenceNum(this.getItem_licenceNum());
        crossRegionalFiling.setItemCompanyType(this.getItem_company_type());
        crossRegionalFiling.setItemBusinessScope(OnlineTaskUtil.scopConvert(this.getItem_businessScope()));
        crossRegionalFiling.setItemWorkAddress(this.getItem_work_address());

        //填写法人信息
        crossRegionalFiling.setItemLegalName(this.getItem_legalName());
        crossRegionalFiling.setItemLegalPhone(this.getItem_legalPhone());
        crossRegionalFiling.setItemLegalType(OnlineTaskUtil.idCardTypeConvert(this.getItem_legalType()));
        crossRegionalFiling.setItemLegalCardnumber(OnlineTaskUtil.decrypt(this.getItem_legalCardnumber()));
        //填写拟开展保安服务项目信息
        crossRegionalFiling.setItemManagerproject(this.getItem_managerproject());
        crossRegionalFiling.setItemSonAddress(this.getItem_sonAddress());
        crossRegionalFiling.setItemContractEndDate(this.getItem_contract_end_date());
        crossRegionalFiling.setItemContractAmount(this.getItem_contract_amount());
        //保安员人数
        if (this.getBayxx()!= null){
            if (this.getBayxx().size() > 0){
                crossRegionalFiling.setItemSonPersonNum(this.getBayxx().get(0).getItem_person_num().toString());
            }
        }
        //保安员
        //项目负责人信息
        crossRegionalFiling.setItemChargeName(this.getItem_chargeName());
        crossRegionalFiling.setItemChargePhone(this.getItem_chargePhone());
        crossRegionalFiling.setItemChargePost(OnlineTaskUtil.jobConvert(this.getItem_chargePost()));
        crossRegionalFiling.setItemChargeCardnumber(OnlineTaskUtil.decrypt(this.getItem_chargeCardnumber()));
        crossRegionalFiling.setItemChargeCardType(OnlineTaskUtil.idCardTypeConvert(this.getMother_name_of_ID_certificate()));
        crossRegionalFiling.setItemChargeSex(this.getItem_sex_2());
        crossRegionalFiling.setItemChargeAge(this.getItem_charge_age());
        crossRegionalFiling.setItemChargeHousehold(this.getItem_charge_household());
        crossRegionalFiling.setItemChargeNation(this.getItem_nation_3());
        crossRegionalFiling.setItemChargeAddress(this.getItem_charge_address());
        crossRegionalFiling.setItemJobResume(this.getItem_job_resume());
        //经办人信息
        crossRegionalFiling.setItemApplicantName(this.getItem_applicant_name());
        crossRegionalFiling.setItemApplicantPhone(this.getItem_applicant_phone());
        //承诺
        crossRegionalFiling.setItemPermit(this.getItem_premit());
        return crossRegionalFiling;
    }
}
