/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.utils;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import com.bcxin.backend.domain.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.imageio.stream.FileImageInputStream;
import org.apache.commons.io.IOUtils;

public final class FileUtils {
    private FileUtils() {
    }

    public static boolean mkdirs(File file) {
        if (null == file) {
            return false;
        }
        if (file.exists()) {
            return false;
        }
        return file.mkdirs();
    }

    public static boolean mkdirs(String directory) {
        if (StringUtils.isBlank((CharSequence)directory)) {
            return false;
        }
        return FileUtils.mkdirs(new File(directory));
    }

    public static boolean delete(File file) {
        if (null == file) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        return file.delete();
    }

    public static boolean delete(String file) {
        if (StringUtils.isBlank((CharSequence)file)) {
            return false;
        }
        return FileUtils.delete(new File(file));
    }

    public static boolean exists(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return false;
        }
        File file = new File(fileName);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileHeader(String file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] header = new byte[4];
            ((InputStream)in).read(header, 0, header.length);
            String string = StringUtils.bytes2Hex(header);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != in) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getFileHeader(byte[] fileData) {
        if (null == fileData) {
            return null;
        }
        byte[] header = new byte[4];
        System.arraycopy(fileData, 0, header, 0, header.length);
        return StringUtils.bytes2Hex(header);
    }

    public static boolean isBmpFile(byte[] fileData) {
        if (null == fileData) {
            return false;
        }
        String header = FileUtils.getFileHeader(fileData).toUpperCase(Locale.ENGLISH);
        header = header.substring(0, 4);
        return "424D".equals(header);
    }

    public static boolean isPdfFile(byte[] fileData) {
        if (null == fileData) {
            return false;
        }
        String header = FileUtils.getFileHeader(fileData).toUpperCase(Locale.ENGLISH);
        header = header.substring(0, 4);
        return "2550".equals(header);
    }

    public static boolean isPdfFile(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return false;
        }
        String header = FileUtils.getFileHeader(filePath).toUpperCase(Locale.ENGLISH);
        header = header.substring(0, 4);
        return "2550".equals(header);
    }

    public static boolean isWordOrExcel(byte[] fileData) {
        if (null == fileData) {
            return false;
        }
        String header = FileUtils.getFileHeader(fileData).toUpperCase(Locale.ENGLISH);
        header = header.substring(0, 4);
        return "D0CF".equals(header);
    }

    public static boolean isPfxFile(byte[] fileData) {
        if (null == fileData) {
            return false;
        }
        String header = FileUtils.getFileHeader(fileData).toUpperCase(Locale.ENGLISH);
        header = header.substring(0, 4);
        return "3082".equals(header);
    }

    public static String getExpandedNameByFileName(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public byte[] image2byte(String path) {
        byte[] data = null;
        FileImageInputStream input = null;
        try {
            input = new FileImageInputStream(new File(path));
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int numBytesRead = 0;
            while ((numBytesRead = input.read(buf)) != -1) {
                output.write(buf, 0, numBytesRead);
            }
            data = output.toByteArray();
            output.close();
            input.close();
        }
        catch (FileNotFoundException ex1) {
            ex1.printStackTrace();
        }
        catch (IOException ex1) {
            ex1.printStackTrace();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readInputStreamToBytes(InputStream in) throws IOException {
        byte[] byArray;
        if (null == in) {
            return null;
        }
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream(4096);
            byte[] data = new byte[4096];
            int len = 0;
            while ((len = in.read(data)) > 0) {
                out.write(data, 0, len);
            }
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileTobytes(String filePath) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(filePath);
            byte[] byArray = IOUtils.toByteArray((InputStream)in);
            return byArray;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != in) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(byte[] data, String filePath) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filePath);
            IOUtils.write((byte[])data, (OutputStream)out);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != out) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String srcFileName, String destFileName, boolean overlay) {
        File srcFile = new File(srcFileName);
        if (!srcFile.exists()) {
            return false;
        }
        if (!srcFile.isFile()) {
            return false;
        }
        File destFile = new File(destFileName);
        if (destFile.exists()) {
            if (overlay) {
                new File(destFileName).delete();
            }
        } else if (!destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
            return false;
        }
        int byteread = 0;
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(srcFile);
            out = new FileOutputStream(destFile);
            byte[] buffer = new byte[1024];
            while ((byteread = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, byteread);
            }
            buffer = null;
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<File> filenames(String path, final String keywork) {
        try {
            File folder = new File(path);
            long currentTime = System.currentTimeMillis();
            final long fiveMinutesAgo = currentTime - 300000L;
            return FileUtil.loopFiles((File)folder, (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.lastModified() >= fiveMinutesAgo && (StringUtils.isEmpty((CharSequence)keywork) || file.getName().startsWith(keywork));
                }
            });
        }
        catch (Exception e) {
            System.err.println("=======>\u83b7\u53d6\u76ee\u5f55\u4e0b\u6240\u6709\u6700\u8fd15\u5206\u949f\u5185\u751f\u6210\u7684\u6587\u4ef6\u7684\u6587\u4ef6\u540d\uff1a" + e.getMessage() + "<=======");
            return new ArrayList<File>();
        }
    }

    public static void delLastDayFile(String path, final String keywork) {
        try {
            File folder = new File(path);
            long currentTime = System.currentTimeMillis();
            final long fiveMinutesAgo = currentTime - 43200000L;
            List list = FileUtil.loopFiles((File)folder, (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.lastModified() <= fiveMinutesAgo && StringUtils.isNotEmpty((CharSequence)keywork) && file.getName().startsWith(keywork);
                }
            });
            for (File file : list) {
                FileUtils.delete(file);
            }
        }
        catch (Exception e) {
            System.err.println("=======>\u83b7\u53d6\u76ee\u5f55\u4e0b12\u5c0f\u65f6\u524d\u4ea7\u751f\u6587\u4ef6\u505a\u5220\u9664\u4e1a\u52a1\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage() + "<=======");
        }
    }

    public static void writeFile(String filePath, String fileName, String content) {
        File file = new File(filePath + File.separator + fileName);
        if (!file.exists()) {
            FileUtil.touch((File)file);
        }
        FileUtil.writeString((String)content, (File)file, (String)"UTF-8");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String urlToBase64(String url) {
        try (InputStream inputStream = new URL(url).openStream();){
            byte[] bytes = IoUtil.readBytes((InputStream)inputStream);
            String string = Base64.encode((byte[])bytes);
            return string;
        }
        catch (Exception e) {
            System.err.println("=======>\u8fdc\u7a0b\u5730\u5740\u8f6cbase64\u5f02\u5e38.urlToBase64\uff0cerr\uff1a" + e.getMessage() + "<=======");
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fileToBase64(String filePath) {
        try (FileInputStream inputStream = new FileInputStream(filePath);){
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            String string = Base64.encode((byte[])bytes);
            return string;
        }
        catch (Exception e) {
            System.err.println("=======>\u670d\u52a1\u5668\u5730\u5740\u8f6cbase64\u5f02\u5e38.fileToBase64\uff0cerr\uff1a" + e.getMessage() + "<=======");
            return "";
        }
    }

    public static void main(String[] args) {
        String a = "C:\\Users\\Administrator\\Downloads\\BBEJ13037125QAAA75PZ.pdf";
        System.out.println(FileUtils.fileToBase64(a));
    }
}

