package com.baichuanxin.openrestapi.common.utils;

import lombok.extern.slf4j.Slf4j;

import java.text.SimpleDateFormat;
import java.util.Date;

@Slf4j
public class DateUtil {
    /**
     * 字符串时间戳转时间
     * @param timestampStr
     * @return
     */
    public static Date getDateTime(String timestampStr) {
        //yyyy-MM-dd HH:mm:ss
        log.info("================时间戳转换==========");
        try {
            long timestamp = Long.parseLong(timestampStr);
            Date date = new Date(timestamp); // 时间戳通常是秒级，所以需要转换为毫秒
            return date;
        } catch (NumberFormatException e) {
            log.info("================时间戳转换:Invalid timestamp==========");
        }
        return null;
    }

    //获取时间并格式化。
    public static String dateFormatter(Date date,String dateFormat){
        SimpleDateFormat simpleDateFormat  =new SimpleDateFormat(dateFormat);
        String format = simpleDateFormat.format(date);
        return format;
    }
}
