/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.document.domains.utils;

import com.bcxin.tenant.open.infrastructures.constants.BusinessConstants;
import com.bcxin.tenant.open.infrastructures.utils.LonLatValueTypeUtils;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.bcxin.tenant.open.infrastructures.valueTypes.LonLatValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.geo.Point;

public class GeoPointUtils {
    private static final Logger logger = LoggerFactory.getLogger(GeoPointUtils.class);
    private static final String LNG_PATTERN = "^[\\-\\+]?(0(\\.\\d{1,6})?|([1-9](\\d)?)(\\.\\d{1,6})?|1[0-7]\\d{1}(\\.\\d{1,6})?|180(\\.0{1,6})?)$";
    private static final String LAT_PATTERN = "^[\\-\\+]?((0|([1-8]\\d?))(\\.\\d{1,6})?|90(\\.0{1,6})?)$";

    public static Point translate(String lonLatString) {
        if (!StringUtil.isEmpty((String)lonLatString)) {
            try {
                LonLatValueType lonLatValue = LonLatValueTypeUtils.translate((String)lonLatString);
                if (lonLatValue != null && lonLatValue.getLat() != null && lonLatValue.getLon() != null && lonLatValue.getLat() > 1.0) {
                    double lonValue = lonLatValue.getLon();
                    double latValue = lonLatValue.getLat();
                    Point lonLat = new Point(lonValue, latValue);
                    return lonLat;
                }
            }
            catch (Exception ex) {
                logger.error("\u5f53\u524d\u7ecf\u7eac\u5ea6\u4fe1\u606f\u65e0\u6548:{}", (Object)lonLatString, (Object)ex);
            }
        }
        return new Point(BusinessConstants.INVALID_LON_LAT.doubleValue(), BusinessConstants.INVALID_LON_LAT.doubleValue());
    }

    public static boolean IsValidGeo(Double lon, Double lat) {
        if (lon == null || lat == null) {
            return false;
        }
        try {
            Point lonLat = new Point(lon.doubleValue(), lat.doubleValue());
            return true;
        }
        catch (Exception ex) {
            logger.error("\u5f53\u524d\u7ecf\u7eac\u5ea6\u4fe1\u606f\u65e0\u6548:{},{}", new Object[]{lon, lat, ex});
            return false;
        }
    }

    public static Point translateFromLocation(double lon, double lat) {
        try {
            return new Point(lon, lat);
        }
        catch (Exception ex) {
            logger.error("\u7ecf\u7eac\u5ea6\u7684\u8f6c\u6362\u5931\u8d25:{}, {}", (Object)lon, (Object)lat);
            return null;
        }
    }
}

