/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ExamType;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import org.springframework.data.annotation.Id;
import org.springframework.util.StringUtils;

@Document(language=SearchLanguage.CHINESE)
public class RdSystemExamInfoDocument
extends EntityAbstract {
    @Id
    @Indexed
    private String id;
    private String name;
    @Indexed
    private Long beginTimeOfTs;
    @Indexed
    private Long endTimeOfTs;
    private LocalDateTime beginTime;
    private LocalDateTime endTime;
    private ExamType examType;
    private String teacherIds;
    @Indexed
    private String examSiteRoomId;
    @Indexed
    private String superviseDepartId;
    @Indexed
    private String organizationId;
    private Timestamp lastSyncTime;

    public int getCountOfTeachers() {
        if (!StringUtils.hasLength((String)this.getTeacherIds())) {
            return 0;
        }
        return (int)Arrays.stream(this.getTeacherIds().split(";")).filter(ii -> StringUtils.hasLength((String)ii)).count();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Long getBeginTimeOfTs() {
        return this.beginTimeOfTs;
    }

    public Long getEndTimeOfTs() {
        return this.endTimeOfTs;
    }

    public LocalDateTime getBeginTime() {
        return this.beginTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public ExamType getExamType() {
        return this.examType;
    }

    public String getTeacherIds() {
        return this.teacherIds;
    }

    public String getExamSiteRoomId() {
        return this.examSiteRoomId;
    }

    public String getSuperviseDepartId() {
        return this.superviseDepartId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Timestamp getLastSyncTime() {
        return this.lastSyncTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBeginTimeOfTs(Long beginTimeOfTs) {
        this.beginTimeOfTs = beginTimeOfTs;
    }

    public void setEndTimeOfTs(Long endTimeOfTs) {
        this.endTimeOfTs = endTimeOfTs;
    }

    public void setBeginTime(LocalDateTime beginTime) {
        this.beginTime = beginTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public void setExamType(ExamType examType) {
        this.examType = examType;
    }

    public void setTeacherIds(String teacherIds) {
        this.teacherIds = teacherIds;
    }

    public void setExamSiteRoomId(String examSiteRoomId) {
        this.examSiteRoomId = examSiteRoomId;
    }

    public void setSuperviseDepartId(String superviseDepartId) {
        this.superviseDepartId = superviseDepartId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void setLastSyncTime(Timestamp lastSyncTime) {
        this.lastSyncTime = lastSyncTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RdSystemExamInfoDocument)) {
            return false;
        }
        RdSystemExamInfoDocument other = (RdSystemExamInfoDocument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$beginTimeOfTs = this.getBeginTimeOfTs();
        Long other$beginTimeOfTs = other.getBeginTimeOfTs();
        if (this$beginTimeOfTs == null ? other$beginTimeOfTs != null : !((Object)this$beginTimeOfTs).equals(other$beginTimeOfTs)) {
            return false;
        }
        Long this$endTimeOfTs = this.getEndTimeOfTs();
        Long other$endTimeOfTs = other.getEndTimeOfTs();
        if (this$endTimeOfTs == null ? other$endTimeOfTs != null : !((Object)this$endTimeOfTs).equals(other$endTimeOfTs)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        LocalDateTime this$beginTime = this.getBeginTime();
        LocalDateTime other$beginTime = other.getBeginTime();
        if (this$beginTime == null ? other$beginTime != null : !((Object)this$beginTime).equals(other$beginTime)) {
            return false;
        }
        LocalDateTime this$endTime = this.getEndTime();
        LocalDateTime other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        ExamType this$examType = this.getExamType();
        ExamType other$examType = other.getExamType();
        if (this$examType == null ? other$examType != null : !this$examType.equals(other$examType)) {
            return false;
        }
        String this$teacherIds = this.getTeacherIds();
        String other$teacherIds = other.getTeacherIds();
        if (this$teacherIds == null ? other$teacherIds != null : !this$teacherIds.equals(other$teacherIds)) {
            return false;
        }
        String this$examSiteRoomId = this.getExamSiteRoomId();
        String other$examSiteRoomId = other.getExamSiteRoomId();
        if (this$examSiteRoomId == null ? other$examSiteRoomId != null : !this$examSiteRoomId.equals(other$examSiteRoomId)) {
            return false;
        }
        String this$superviseDepartId = this.getSuperviseDepartId();
        String other$superviseDepartId = other.getSuperviseDepartId();
        if (this$superviseDepartId == null ? other$superviseDepartId != null : !this$superviseDepartId.equals(other$superviseDepartId)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        Timestamp this$lastSyncTime = this.getLastSyncTime();
        Timestamp other$lastSyncTime = other.getLastSyncTime();
        return !(this$lastSyncTime == null ? other$lastSyncTime != null : !((Object)this$lastSyncTime).equals(other$lastSyncTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RdSystemExamInfoDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $beginTimeOfTs = this.getBeginTimeOfTs();
        result = result * 59 + ($beginTimeOfTs == null ? 43 : ((Object)$beginTimeOfTs).hashCode());
        Long $endTimeOfTs = this.getEndTimeOfTs();
        result = result * 59 + ($endTimeOfTs == null ? 43 : ((Object)$endTimeOfTs).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        LocalDateTime $beginTime = this.getBeginTime();
        result = result * 59 + ($beginTime == null ? 43 : ((Object)$beginTime).hashCode());
        LocalDateTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        ExamType $examType = this.getExamType();
        result = result * 59 + ($examType == null ? 43 : $examType.hashCode());
        String $teacherIds = this.getTeacherIds();
        result = result * 59 + ($teacherIds == null ? 43 : $teacherIds.hashCode());
        String $examSiteRoomId = this.getExamSiteRoomId();
        result = result * 59 + ($examSiteRoomId == null ? 43 : $examSiteRoomId.hashCode());
        String $superviseDepartId = this.getSuperviseDepartId();
        result = result * 59 + ($superviseDepartId == null ? 43 : $superviseDepartId.hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        Timestamp $lastSyncTime = this.getLastSyncTime();
        result = result * 59 + ($lastSyncTime == null ? 43 : ((Object)$lastSyncTime).hashCode());
        return result;
    }

    public String toString() {
        return "RdSystemExamInfoDocument(id=" + this.getId() + ", name=" + this.getName() + ", beginTimeOfTs=" + this.getBeginTimeOfTs() + ", endTimeOfTs=" + this.getEndTimeOfTs() + ", beginTime=" + this.getBeginTime() + ", endTime=" + this.getEndTime() + ", examType=" + this.getExamType() + ", teacherIds=" + this.getTeacherIds() + ", examSiteRoomId=" + this.getExamSiteRoomId() + ", superviseDepartId=" + this.getSuperviseDepartId() + ", organizationId=" + this.getOrganizationId() + ", lastSyncTime=" + this.getLastSyncTime() + ")";
    }
}

