/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.valueTypes.LonLatValueType;
import com.bcxin.tenant.open.jdks.requests.SearchRequestAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Schema(name="SearchNearByCompanyRequest", title="SearchNearByCompanyRequest \u6839\u636e\u5750\u6807\u641c\u7d22\u5468\u8fb9")
public class SearchNearByCompanyRequest
extends SearchRequestAbstract {
    @Schema(name="locations", title="\u5750\u6807\u96c6\u5408")
    private Collection<LonLatValueType> locations;
    @Schema(name="distance", title="\u5468\u8fb9\u641c\u7d22\u7684\u534a\u5f84\u957f\u5ea6\u5b9a\u4e49,\u5355\u4f4d\u4e3a\u7c73")
    private double distance;
    @Schema(name="institutional", title="\u673a\u6784\u7c7b\u578b")
    private Collection<String> institutional;

    public static SearchNearByCompanyRequest createForSecurityDepart(Collection<LonLatValueType> locations) {
        SearchNearByCompanyRequest request = new SearchNearByCompanyRequest();
        request.setDistance(5000.0);
        request.setLocations(locations);
        request.setInstitutional(Stream.of("0107", "0108", "0109").collect(Collectors.toUnmodifiableList()));
        return request;
    }

    public Collection<LonLatValueType> getLocations() {
        return this.locations;
    }

    public double getDistance() {
        return this.distance;
    }

    public Collection<String> getInstitutional() {
        return this.institutional;
    }

    public void setLocations(Collection<LonLatValueType> locations) {
        this.locations = locations;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public void setInstitutional(Collection<String> institutional) {
        this.institutional = institutional;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchNearByCompanyRequest)) {
            return false;
        }
        SearchNearByCompanyRequest other = (SearchNearByCompanyRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getDistance(), other.getDistance()) != 0) {
            return false;
        }
        Collection<LonLatValueType> this$locations = this.getLocations();
        Collection<LonLatValueType> other$locations = other.getLocations();
        if (this$locations == null ? other$locations != null : !((Object)this$locations).equals(other$locations)) {
            return false;
        }
        Collection<String> this$institutional = this.getInstitutional();
        Collection<String> other$institutional = other.getInstitutional();
        return !(this$institutional == null ? other$institutional != null : !((Object)this$institutional).equals(other$institutional));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SearchNearByCompanyRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $distance = Double.doubleToLongBits(this.getDistance());
        result = result * 59 + (int)($distance >>> 32 ^ $distance);
        Collection<LonLatValueType> $locations = this.getLocations();
        result = result * 59 + ($locations == null ? 43 : ((Object)$locations).hashCode());
        Collection<String> $institutional = this.getInstitutional();
        result = result * 59 + ($institutional == null ? 43 : ((Object)$institutional).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SearchNearByCompanyRequest(locations=" + this.getLocations() + ", distance=" + this.getDistance() + ", institutional=" + this.getInstitutional() + ")";
    }
}

