/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.responses;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.util.StringUtils;
import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.text.SimpleDateFormat;
import java.util.Date;

@Schema(name="SponsorDispatchLogSearchResponse", title="SponsorDispatchLogSearchResponse \u53d1\u8d77\u8005\u7684\u8c03\u5ea6\u4fe1\u606f")
public class SponsorDispatchLogSearchResponse
extends ResponseAbstract {
    @ExcelProperty(value={"\u8c03\u5ea6\u7f16\u53f7"})
    @Schema(name="pkId", title="\u8c03\u5ea6\u7f16\u53f7")
    private final String pkId;
    @ExcelIgnore
    @Schema(name="id", title="\u4e3b\u952e")
    private final String id;
    @ExcelProperty(value={"\u8c03\u5ea6\u5f00\u59cb\u65f6\u95f4"})
    @Schema(name="BeginTime", title="\u8c03\u5ea6\u5f00\u59cb\u65f6\u95f4")
    private String beginTime;
    @ExcelProperty(value={"\u8c03\u5ea6\u7ed3\u675f\u65f6\u95f4"})
    @Schema(name="endTime", title="\u8c03\u5ea6\u7ed3\u675f\u65f6\u95f4")
    private final String endTime;
    @ExcelProperty(value={"\u8c03\u5ea6\u65b9\u5f0f"})
    @Schema(name="communicatedType", title="\u8c03\u5ea6\u65b9\u5f0f")
    private final String communicatedType;
    @ColumnWidth(value=50)
    @ExcelProperty(value={"\u8c03\u5ea6\u65b9"})
    @Schema(name="callerCompanyName", title="\u8c03\u5ea6\u65b9")
    private final String callerCompanyName;
    @ExcelProperty(value={"\u8c03\u5ea6\u4eba"})
    @Schema(name="callerUserName", title="\u8c03\u5ea6\u4eba")
    private final String callerUserName;
    @Schema(name="dispatchTime", title="\u8c03\u5ea6\u65f6\u957f(\u5206\u949f)")
    private final int dispatchTime;

    public SponsorDispatchLogSearchResponse(String pkId, String id, Date beginTime, Date endTime, CommunicatedType communicatedType, String callerCompanyName, String callerUserName) {
        this.pkId = pkId;
        this.id = id;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.beginTime = dateFormat.format(beginTime);
        this.endTime = dateFormat.format(endTime);
        this.communicatedType = communicatedType.getTypeName();
        this.callerCompanyName = callerCompanyName;
        this.callerUserName = callerUserName;
        this.dispatchTime = endTime != null && beginTime != null ? (int)Math.ceil((double)(endTime.getTime() - beginTime.getTime()) * 1.0 / 1000.0 / 60.0) : -1;
    }

    public static SponsorDispatchLogSearchResponse create(String pkId, String id, Date beginTime, Date endTime, String communicatedType, String callerCompanyName, String callerUserName) {
        CommunicatedType ct = CommunicatedType.Audio;
        if (!StringUtils.isEmpty((CharSequence)communicatedType) && communicatedType.equalsIgnoreCase(String.valueOf(CommunicatedType.Video.ordinal()))) {
            ct = CommunicatedType.Video;
        }
        return new SponsorDispatchLogSearchResponse(pkId, id, beginTime, endTime, ct, callerCompanyName, callerUserName);
    }

    public String getPkId() {
        return this.pkId;
    }

    public String getId() {
        return this.id;
    }

    public String getBeginTime() {
        return this.beginTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getCommunicatedType() {
        return this.communicatedType;
    }

    public String getCallerCompanyName() {
        return this.callerCompanyName;
    }

    public String getCallerUserName() {
        return this.callerUserName;
    }

    public int getDispatchTime() {
        return this.dispatchTime;
    }
}

