/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RollCallStatus;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class RollCallAutoCancelEmployeeResponse
extends ResponseAbstract {
    private final Collection<RollCallAutoCancelEmployeeResponseItem> items;

    public int getAffectedCount() {
        if (CollectionUtils.isEmpty(this.getItems())) {
            return 0;
        }
        return this.getItems().size();
    }

    public RollCallAutoCancelEmployeeResponse(Collection<RollCallAutoCancelEmployeeResponseItem> items) {
        this.items = items;
    }

    public static RollCallAutoCancelEmployeeResponse create(Collection<RollCallAutoCancelEmployeeResponseItem> items) {
        return new RollCallAutoCancelEmployeeResponse(items);
    }

    public Collection<RollCallAutoCancelEmployeeResponseItem> getItems() {
        return this.items;
    }

    public static class RollCallAutoCancelEmployeeResponseItem
    extends ResponseAbstract {
        private final String rollCallEmployeeId;
        private final String rollCallStatusLabel;

        public RollCallAutoCancelEmployeeResponseItem(String rollCallEmployeeId, int rollCallStatuses) {
            this.rollCallEmployeeId = rollCallEmployeeId;
            Collection callStatuses = RollCallStatus.getSelectedRollCallStatuses((int)rollCallStatuses);
            this.rollCallStatusLabel = CollectionUtils.isEmpty((Collection)callStatuses) ? "\u65e0" : callStatuses.stream().map(ii -> ii.getName()).collect(Collectors.joining(";"));
        }

        public static RollCallAutoCancelEmployeeResponseItem create(String rollCallEmployeeId, int rollCallStatuses) {
            return new RollCallAutoCancelEmployeeResponseItem(rollCallEmployeeId, rollCallStatuses);
        }

        public String getRollCallEmployeeId() {
            return this.rollCallEmployeeId;
        }

        public String getRollCallStatusLabel() {
            return this.rollCallStatusLabel;
        }
    }
}

