/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.jdks.responses.WorkstationResponse;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

@Schema(name="AttendanceValidationResponse", title="\u8fd4\u56de\u9a8c\u8bc1\u7ed3\u679c")
public class AttendanceValidationResponse
extends ResponseAbstract {
    @Schema(name="id", title="\u9a7b\u52e4\u70b9Id")
    private final String id;
    @Schema(name="name", title="\u9a7b\u52e4\u70b9\u540d\u79f0")
    private final String name;
    @Schema(name="address", title="\u9a7b\u52e4\u70b9\u5730\u5740")
    private final String address;
    @Schema(name="latitude", title="\u9a7b\u52e4\u70b9\u6240\u5728y\u8f74\u5750\u6807")
    private final Double latitude;
    @Schema(name="longitude", title="\u9a7b\u52e4\u70b9\u6240\u5728x\u8f74\u5750\u6807")
    private final Double longitude;
    @Schema(name="performRange", title="\u9a7b\u52e4\u70b9\u7684\u6267\u884c\u8303\u56f4\uff08\u5355\u4f4d\u4e3a\u7c73\uff09")
    private final Double performRange;
    @Schema(name="enableFaceValidation", title="\u662f\u5426\u542f\u7528\u4eba\u8138\u9a8c\u8bc1; false\u4e3a\u7981\u7528\u4eba\u8138\u8bc6\u522b,\u5176\u4ed6\u5219\u542f\u7528")
    private final boolean enableFaceValidation;
    @Schema(name="ignoredPerformRangeLimited", title="\u662f\u5426\u5ffd\u7565\u6267\u884c\u8303\u56f4\u7684\u7b7e\u5230\u9650\u5236")
    private final boolean ignoredPerformRangeLimited;
    @Schema(name="actionCode", title="\u7528\u4e8e\u4e0b\u4e00\u6b65\u7684\u63d0\u4ea4\u7b7e\u5230/\u7b7e\u9000\u7684\u52a8\u4f5c\u4f9d\u636e")
    private String actionCode;
    @Schema(name="workstations", title="\u5176\u4ed6\u5de5\u4f5c\u70b9(\u9a7b\u52e4\u70b9/\u5c97\u70b9/\u70b9\u4f4d\u4fe1\u606f);\u5f53\u6b64\u96c6\u5408\u4e3a\u975e\u7a7a\u7684\u65f6\u5019; \u7b7e\u5230\u7684\u65f6\u5019\u5c55\u793a\u8be5\u5217\u8868\uff0c\u8ba9\u7528\u6237\u8fdb\u884c\u5f39\u6846\u9009\u62e9\u8981\u7b7e\u7684\u70b9\u4f4d\u4fe1\u606f")
    private Collection<WorkstationValidationResponse> workstations;

    public AttendanceValidationResponse(String id, String name, String address, Double latitude, Double longitude, Double performRange, boolean enableFaceValidation, boolean ignoredPerformRangeLimited) {
        this.id = id;
        this.name = name;
        this.address = address;
        this.latitude = latitude;
        this.longitude = longitude;
        this.performRange = performRange;
        this.enableFaceValidation = enableFaceValidation;
        this.ignoredPerformRangeLimited = ignoredPerformRangeLimited;
    }

    public static AttendanceValidationResponse create(String id, String name, String address, Double latitude, Double longitude, Double performRange, boolean enableFaceValidation, boolean ignoredPerformRangeLimited) {
        return new AttendanceValidationResponse(id, name, address, latitude, longitude, performRange, enableFaceValidation, ignoredPerformRangeLimited);
    }

    public void generateActionCode(String employeeId, String stationId) {
        this.actionCode = String.format("%s#%s", employeeId, stationId);
    }

    public void assignWorkstations(Collection<WorkstationValidationResponse> workstations) {
        String currentStationId = this.getId();
        Collection matchedWorkStations = workstations;
        if (!CollectionUtils.isEmpty(workstations) && workstations.size() == 1) {
            matchedWorkStations = workstations.stream().filter(ii -> !ii.getId().equalsIgnoreCase(currentStationId)).collect(Collectors.toList());
        }
        this.workstations = matchedWorkStations;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Double getPerformRange() {
        return this.performRange;
    }

    public boolean isEnableFaceValidation() {
        return this.enableFaceValidation;
    }

    public boolean isIgnoredPerformRangeLimited() {
        return this.ignoredPerformRangeLimited;
    }

    public String getActionCode() {
        return this.actionCode;
    }

    public Collection<WorkstationValidationResponse> getWorkstations() {
        return this.workstations;
    }

    public static class WorkstationValidationResponse
    extends WorkstationResponse {
        @Schema(name="ignoredPerformRangeLimited", title="\u662f\u5426\u5ffd\u7565\u6267\u884c\u8303\u56f4\u7684\u7b7e\u5230\u9650\u5236")
        private final boolean ignoredPerformRangeLimited;
        @Schema(name="actionCode", title="\u7528\u4e8e\u4e0b\u4e00\u6b65\u7684\u63d0\u4ea4\u7b7e\u5230/\u7b7e\u9000\u7684\u52a8\u4f5c\u4f9d\u636e")
        private String actionCode;

        public WorkstationValidationResponse(WorkstationResponse response, boolean ignoredPerformRangeLimited) {
            super(response.getId(), response.getLatitude(), response.getLongitude(), response.getDisplayOrder(), response.getName(), response.getAddress(), response.getPerformRange(), response.getReferenceType(), response.getReferenceLineId());
            this.ignoredPerformRangeLimited = ignoredPerformRangeLimited;
        }

        public void generateActionCode(String employeeId) {
            this.actionCode = String.format("%s#%s", employeeId, this.getId());
        }

        public static WorkstationValidationResponse create(String employeeId, WorkstationResponse response, boolean ignoredPerformRangeLimited) {
            WorkstationValidationResponse wvr = new WorkstationValidationResponse(response, ignoredPerformRangeLimited);
            wvr.generateActionCode(employeeId);
            return wvr;
        }

        public boolean isIgnoredPerformRangeLimited() {
            return this.ignoredPerformRangeLimited;
        }

        public String getActionCode() {
            return this.actionCode;
        }
    }
}

