/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.infrastructures.valueTypes;

import com.bcxin.tenant.open.infrastructures.valueTypes.ValueTypeAbstract;

public class GeoLocationValueType
extends ValueTypeAbstract {
    private double lat;
    private double lon;
    private AddressRequest address;

    public static GeoLocationValueType create(double lat, double lon, AddressRequest address) {
        GeoLocationValueType geoLocation = new GeoLocationValueType();
        geoLocation.setLon(lon);
        geoLocation.setLat(lat);
        geoLocation.setAddress(address);
        return geoLocation;
    }

    public static boolean isValidLocation(Double lat, Double lon) {
        if (lat == null || lon == null) {
            return false;
        }
        try {
            String latString = lat.toString();
            String lonString = lon.toString();
            if (!latString.contains(".") || !lonString.contains(".")) {
                return false;
            }
            return latString.length() - latString.indexOf(".") >= 4 && lonString.length() - lonString.indexOf(".") >= 4;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public AddressRequest getAddress() {
        return this.address;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public void setLon(double lon) {
        this.lon = lon;
    }

    public void setAddress(AddressRequest address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeoLocationValueType)) {
            return false;
        }
        GeoLocationValueType other = (GeoLocationValueType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLat(), other.getLat()) != 0) {
            return false;
        }
        if (Double.compare(this.getLon(), other.getLon()) != 0) {
            return false;
        }
        AddressRequest this$address = this.getAddress();
        AddressRequest other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !((Object)this$address).equals(other$address));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeoLocationValueType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lat = Double.doubleToLongBits(this.getLat());
        result = result * 59 + (int)($lat >>> 32 ^ $lat);
        long $lon = Double.doubleToLongBits(this.getLon());
        result = result * 59 + (int)($lon >>> 32 ^ $lon);
        AddressRequest $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        return result;
    }

    public String toString() {
        return "GeoLocationValueType(lat=" + this.getLat() + ", lon=" + this.getLon() + ", address=" + this.getAddress() + ")";
    }

    public static class AddressRequest
    extends ValueTypeAbstract {
        private String country;
        private String province;
        private String city;
        private String district;
        private String street;
        private String streetNum;
        private String poiName;
        private String cityCode;

        public static AddressRequest create(String country, String province, String city, String district, String street, String streetNum, String poiName, String cityCode) {
            AddressRequest addressRequest = new AddressRequest();
            addressRequest.setCity(city);
            addressRequest.setCountry(country);
            addressRequest.setProvince(province);
            addressRequest.setDistrict(district);
            addressRequest.setStreet(street);
            addressRequest.setStreetNum(streetNum);
            addressRequest.setPoiName(poiName);
            addressRequest.setCityCode(cityCode);
            return addressRequest;
        }

        public String getCountry() {
            return this.country;
        }

        public String getProvince() {
            return this.province;
        }

        public String getCity() {
            return this.city;
        }

        public String getDistrict() {
            return this.district;
        }

        public String getStreet() {
            return this.street;
        }

        public String getStreetNum() {
            return this.streetNum;
        }

        public String getPoiName() {
            return this.poiName;
        }

        public String getCityCode() {
            return this.cityCode;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public void setDistrict(String district) {
            this.district = district;
        }

        public void setStreet(String street) {
            this.street = street;
        }

        public void setStreetNum(String streetNum) {
            this.streetNum = streetNum;
        }

        public void setPoiName(String poiName) {
            this.poiName = poiName;
        }

        public void setCityCode(String cityCode) {
            this.cityCode = cityCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddressRequest)) {
                return false;
            }
            AddressRequest other = (AddressRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$province = this.getProvince();
            String other$province = other.getProvince();
            if (this$province == null ? other$province != null : !this$province.equals(other$province)) {
                return false;
            }
            String this$city = this.getCity();
            String other$city = other.getCity();
            if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                return false;
            }
            String this$district = this.getDistrict();
            String other$district = other.getDistrict();
            if (this$district == null ? other$district != null : !this$district.equals(other$district)) {
                return false;
            }
            String this$street = this.getStreet();
            String other$street = other.getStreet();
            if (this$street == null ? other$street != null : !this$street.equals(other$street)) {
                return false;
            }
            String this$streetNum = this.getStreetNum();
            String other$streetNum = other.getStreetNum();
            if (this$streetNum == null ? other$streetNum != null : !this$streetNum.equals(other$streetNum)) {
                return false;
            }
            String this$poiName = this.getPoiName();
            String other$poiName = other.getPoiName();
            if (this$poiName == null ? other$poiName != null : !this$poiName.equals(other$poiName)) {
                return false;
            }
            String this$cityCode = this.getCityCode();
            String other$cityCode = other.getCityCode();
            return !(this$cityCode == null ? other$cityCode != null : !this$cityCode.equals(other$cityCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AddressRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $province = this.getProvince();
            result = result * 59 + ($province == null ? 43 : $province.hashCode());
            String $city = this.getCity();
            result = result * 59 + ($city == null ? 43 : $city.hashCode());
            String $district = this.getDistrict();
            result = result * 59 + ($district == null ? 43 : $district.hashCode());
            String $street = this.getStreet();
            result = result * 59 + ($street == null ? 43 : $street.hashCode());
            String $streetNum = this.getStreetNum();
            result = result * 59 + ($streetNum == null ? 43 : $streetNum.hashCode());
            String $poiName = this.getPoiName();
            result = result * 59 + ($poiName == null ? 43 : $poiName.hashCode());
            String $cityCode = this.getCityCode();
            result = result * 59 + ($cityCode == null ? 43 : $cityCode.hashCode());
            return result;
        }

        public String toString() {
            return "GeoLocationValueType.AddressRequest(country=" + this.getCountry() + ", province=" + this.getProvince() + ", city=" + this.getCity() + ", district=" + this.getDistrict() + ", street=" + this.getStreet() + ", streetNum=" + this.getStreetNum() + ", poiName=" + this.getPoiName() + ", cityCode=" + this.getCityCode() + ")";
        }
    }
}

