/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.infrastructures.enums;

import java.util.ArrayList;
import java.util.Collection;

public enum CompanyLevel {
    Basic(1, "\u57fa\u672c\u5305"),
    Premium(2, "\u9ad8\u7ea7\u5305");

    int value;
    String name;

    private CompanyLevel(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public static int calculate(Collection<CompanyLevel> organizationLevels) {
        int result = 0;
        if (organizationLevels != null || !organizationLevels.isEmpty()) {
            for (CompanyLevel organizationLevel : organizationLevels) {
                result |= organizationLevel.value;
            }
        }
        return result;
    }

    public static Collection<CompanyLevel> getLevels(int level) {
        ArrayList<CompanyLevel> result = new ArrayList<CompanyLevel>();
        for (CompanyLevel organizationLevel1 : CompanyLevel.values()) {
            if ((level & organizationLevel1.value) <= 0) continue;
            result.add(organizationLevel1);
        }
        return result;
    }

    public static boolean contain(int organizationLevelValue, CompanyLevel level) {
        return CompanyLevel.getLevels(organizationLevelValue).contains((Object)level);
    }
}

