/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.infrastructures.criterias;

public abstract class CriteriaAbstract {
    public static final int IGNORE_PAGE_FOR_SIZE = Integer.MAX_VALUE;
    private final int pageIndex;
    private final int pageSize;
    private boolean forExport;

    public int getSkip() {
        int skip = (this.getPageIndex() - 1) * this.getPageSize();
        if (skip < 0) {
            skip = 0;
        }
        return skip;
    }

    protected CriteriaAbstract(int pageIndex, int pageSize) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }

    protected CriteriaAbstract() {
        this(1, 20);
    }

    public boolean ignorePage() {
        return this.getPageSize() == Integer.MAX_VALUE || this.isForExport();
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean isForExport() {
        return this.forExport;
    }

    public void setForExport(boolean forExport) {
        this.forExport = forExport;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CriteriaAbstract)) {
            return false;
        }
        CriteriaAbstract other = (CriteriaAbstract)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageIndex() != other.getPageIndex()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        return this.isForExport() == other.isForExport();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CriteriaAbstract;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageIndex();
        result = result * 59 + this.getPageSize();
        result = result * 59 + (this.isForExport() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "CriteriaAbstract(pageIndex=" + this.getPageIndex() + ", pageSize=" + this.getPageSize() + ", forExport=" + this.isForExport() + ")";
    }
}

