/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DispatchAccountType;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import org.springframework.util.StringUtils;

public class CreateTenantAccountCommand
extends CommandAbstract {
    private final Boolean sosEnabled;
    private final String sosKey;
    private final String deviceNo;
    private final String creatorId;
    private final String creatorName;
    private final DispatchAccountType accountType;

    public CreateTenantAccountCommand(DispatchAccountType accountType, Boolean sosEnabled, String sosKey, String deviceNo, String creatorId, String creatorName) {
        this.sosEnabled = sosEnabled;
        this.sosKey = sosKey;
        this.deviceNo = deviceNo;
        this.creatorId = creatorId;
        this.creatorName = creatorName;
        this.accountType = accountType;
    }

    public void validate() {
        super.validate();
        if (this.getSosEnabled() == null) {
            throw new BadTenantException("Sos\u8bbe\u5907\u662f\u5426\u5f00\u542f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!StringUtils.hasLength((String)this.getSosKey()) && this.getSosEnabled().booleanValue()) {
            throw new BadTenantException("Sos\u8bbe\u5907\u662f\u5426\u5f00\u542f\u4e3aTrue\u7684\u60c5\u51b5\u4e0bSosKey\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    public static CreateTenantAccountCommand create(DispatchAccountType accountType, Boolean sosEnabled, String sosKey, String deviceNo, String creatorId, String creatorName) {
        CreateTenantAccountCommand command = new CreateTenantAccountCommand(accountType, sosEnabled, sosKey, deviceNo, creatorId, creatorName);
        return command;
    }

    public Boolean getSosEnabled() {
        return this.sosEnabled;
    }

    public String getSosKey() {
        return this.sosKey;
    }

    public String getDeviceNo() {
        return this.deviceNo;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public DispatchAccountType getAccountType() {
        return this.accountType;
    }
}

