/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.tenant.open.domains.entities.ConfigOfBillEntity;
import com.bcxin.tenant.open.domains.entities.DailyBillEntity;
import com.bcxin.tenant.open.domains.entities.MonthlyBillEntity;
import com.bcxin.tenant.open.domains.pojo.DailyBillPojo;
import com.bcxin.tenant.open.domains.pojo.MonthBillPojo;
import com.bcxin.tenant.open.infrastructures.enums.BillPaymentStatus;
import com.bcxin.tenant.open.infrastructures.enums.BillType;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class BillUtils {
    public static String getMonthBillId(String orgId, Date date, BillType type) {
        return String.format("%s-%s-%s", orgId, type.ordinal(), new SimpleDateFormat("yyyyMM").format(date));
    }

    public static String getDateFormat(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String getDailyBillId(String orgId, Date date, BillType type) {
        return String.format("%s-%s-%s", orgId, type.ordinal(), new SimpleDateFormat("yyyyMM-dd").format(date));
    }

    public static boolean isFirstDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfMonth = calendar.get(5);
        return dayOfMonth == 1;
    }

    public static DailyBillEntity createDailyBillEntity(DailyBillPojo attendancePojo, Date date, BillType billType) {
        int opeCount = attendancePojo.getOpeCount();
        String orgId = attendancePojo.getOrgId();
        DailyBillEntity dailyBillEntity = DailyBillEntity.create(BillUtils.getDailyBillId(orgId, date, billType), billType, orgId, java.sql.Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(date)), BillUtils.getMonthBillId(orgId, date, billType), opeCount, attendancePojo.getHeadCount());
        return dailyBillEntity;
    }

    public static MonthlyBillEntity createMonthlyBillEntity(ConfigOfBillEntity configOfBill, MonthBillPojo billPojo, BillType type, Date date) {
        int opePerCalc = 1;
        int pointsPerCalc = 0;
        switch (type) {
            case Attendance: {
                opePerCalc = configOfBill.getSignDo();
                pointsPerCalc = configOfBill.getSignMinutePerson();
                break;
            }
            case RollCall: {
                opePerCalc = configOfBill.getCallDo();
                pointsPerCalc = configOfBill.getCallMinutePerson();
                break;
            }
            case Track: {
                opePerCalc = configOfBill.getTrackDo();
                pointsPerCalc = configOfBill.getTrackMinutePerson();
                break;
            }
            case Fence: {
                opePerCalc = configOfBill.getFenceDo();
                pointsPerCalc = configOfBill.getFenceMinutePerson();
                break;
            }
            case Audio: {
                pointsPerCalc = configOfBill.getAudioMinutePerson();
                break;
            }
            case Video: {
                pointsPerCalc = configOfBill.getVideoMinutePerson();
            }
        }
        int opeCount = billPojo.getCount();
        int amount = (opeCount / opePerCalc + (opeCount % opePerCalc == 0 ? 0 : 1)) * pointsPerCalc;
        String configStr = JSON.toJSONString((Object)((Object)configOfBill), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        return MonthlyBillEntity.create(BillUtils.getMonthBillId(billPojo.getOrgId(), date, type), type, billPojo.getOrgId(), BillPaymentStatus.Unpaid, null, new SimpleDateFormat("yyyyMM").format(date), amount, 0, billPojo.getCount(), configStr, 1);
    }

    public static Date getNextDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        return calendar.getTime();
    }

    public static Date getMin(Date date1, Date date2) {
        int cmpResult = BillUtils.compareDate(date1, date2);
        if (cmpResult <= 0) {
            return date1;
        }
        return date2;
    }

    public static Date getLastDateOfCurOrPreMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (calendar.getActualMaximum(5) == calendar.get(5)) {
            return date;
        }
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static int compareMonth(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return 0;
        }
        if (date1 == null) {
            return -1;
        }
        if (date2 == null) {
            return 1;
        }
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        int year1 = calendar1.get(1);
        int month1 = calendar1.get(2);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        int year2 = calendar2.get(1);
        int month2 = calendar2.get(2);
        if (year1 < year2) {
            return -1;
        }
        if (year1 > year2) {
            return 1;
        }
        if (month1 < month2) {
            return -1;
        }
        if (month1 > month2) {
            return 1;
        }
        return 0;
    }

    public static int compareMonth(String m1, String m2) {
        if (m1 == null && m2 == null) {
            return 0;
        }
        if (m1 == null) {
            return -1;
        }
        if (m2 == null) {
            return 1;
        }
        return m1.compareTo(m2);
    }

    public static Date getLastDateOfPreviousMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static Date getPreviousMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        return calendar.getTime();
    }

    public static Date getNextMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        return calendar.getTime();
    }

    public static Date getFirstDateOfNextMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.add(2, 1);
        return calendar.getTime();
    }

    public static Date getPreviousDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static int compareDate(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return 0;
        }
        if (date1 == null) {
            return -1;
        }
        if (date2 == null) {
            return 1;
        }
        int monthCompRst = BillUtils.compareMonth(date1, date2);
        if (monthCompRst == 0) {
            Calendar calendar1 = Calendar.getInstance();
            calendar1.setTime(date1);
            int day1 = calendar1.get(5);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(date2);
            int day2 = calendar2.get(5);
            return day1 - day2;
        }
        return monthCompRst;
    }
}

