/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.eventListeners;

import com.bcxin.tenant.open.document.domains.documents.RollCallProgressStatusDocument;
import com.bcxin.tenant.open.document.domains.documents.RollCallProgressStatusDocument$;
import com.bcxin.tenant.open.document.domains.repositories.RollCallProgressStatusDocumentRepository;
import com.bcxin.tenant.open.domains.entities.RollCallEmployeeEntity;
import com.bcxin.tenant.open.domains.events.ReplyRollCallEmployeeStatusEvent;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.SearchStream;
import com.redis.om.spring.search.stream.predicates.SearchFieldPredicate;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ReplyRollCallEmployeeStatusEventListener
implements ApplicationListener<ReplyRollCallEmployeeStatusEvent> {
    private final EntityStream entityStream;
    private final RollCallProgressStatusDocumentRepository rollCallProgressStatusDocumentRepository;

    public ReplyRollCallEmployeeStatusEventListener(EntityStream entityStream, RollCallProgressStatusDocumentRepository rollCallProgressStatusDocumentRepository) {
        this.entityStream = entityStream;
        this.rollCallProgressStatusDocumentRepository = rollCallProgressStatusDocumentRepository;
    }

    public void onApplicationEvent(ReplyRollCallEmployeeStatusEvent event) {
        Collection<RollCallEmployeeEntity> selectedManuallyRollCallEmployees = event.getRollCallEmployees();
        if (!CollectionUtils.isEmpty(selectedManuallyRollCallEmployees)) {
            SearchStream rollCallProgressStatusDocumentSearchStream = this.entityStream.of(RollCallProgressStatusDocument.class);
            Object[] rollCallIds = (Long[])selectedManuallyRollCallEmployees.stream().map(ii -> ii.getRollCallId()).distinct().collect(Collectors.toList()).toArray(Long[]::new);
            rollCallProgressStatusDocumentSearchStream = rollCallProgressStatusDocumentSearchStream.filter((SearchFieldPredicate)RollCallProgressStatusDocument$.ID.in(rollCallIds));
            Collection documents = (Collection)rollCallProgressStatusDocumentSearchStream.collect(Collectors.toList());
            for (Object rollCallId : rollCallIds) {
                RollCallProgressStatusDocument selectedDocument = documents.stream().filter(arg_0 -> ReplyRollCallEmployeeStatusEventListener.lambda$onApplicationEvent$2((Long)rollCallId, arg_0)).findFirst().orElse(null);
                if (selectedDocument == null) continue;
                Collection selectedRollCallEmployees = selectedManuallyRollCallEmployees.stream().filter(arg_0 -> ReplyRollCallEmployeeStatusEventListener.lambda$onApplicationEvent$3((Long)rollCallId, arg_0)).collect(Collectors.toList());
                selectedDocument.incrProcessed(selectedRollCallEmployees.size());
            }
            this.rollCallProgressStatusDocumentRepository.saveAll((Iterable)documents);
        }
    }

    private static /* synthetic */ boolean lambda$onApplicationEvent$3(Long rollCallId, RollCallEmployeeEntity ii) {
        return ii.getRollCallId().equals(rollCallId);
    }

    private static /* synthetic */ boolean lambda$onApplicationEvent$2(Long rollCallId, RollCallProgressStatusDocument ii) {
        return ii.getId().equals(rollCallId);
    }
}

