/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.bcxin.tenant.open.domains.entities.UserPurseEntity;
import com.bcxin.tenant.open.domains.entities.UserPurseTransactionEntity;
import com.bcxin.tenant.open.domains.mappers.UserPurseMapper;
import com.bcxin.tenant.open.domains.mappers.dtos.UserPurseUpdateDTO;
import com.bcxin.tenant.open.domains.repositories.UserPurseRepository;
import com.bcxin.tenant.open.infrastructures.exceptions.ForbidTenantException;
import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;

@Repository
public class UserPurseRepositoryImpl
implements UserPurseRepository {
    private final UserPurseMapper userPurseMapper;

    public UserPurseRepositoryImpl(UserPurseMapper userPurseMapper) {
        this.userPurseMapper = userPurseMapper;
    }

    public UserPurseEntity getById(Object id) {
        return (UserPurseEntity)this.userPurseMapper.selectById((Serializable)((Object)((String)id)));
    }

    public void insert(UserPurseEntity data) {
        throw new ForbidTenantException();
    }

    public void update(UserPurseEntity data) {
        throw new ForbidTenantException();
    }

    public void addTransactions(Collection<UserPurseTransactionEntity> entities) {
        Collection userPurseIds = entities.stream().map(ii -> ii.getUserPurseId()).distinct().collect(Collectors.toList());
        Collection userPurseUpdateDTOS = userPurseIds.stream().map(ii -> {
            UserPurseUpdateDTO userPurseUpdateDTO = UserPurseUpdateDTO.create(ii, entities.stream().filter(ix -> ix.getUserPurseId().equalsIgnoreCase((String)ii)).collect(Collectors.toList()));
            return userPurseUpdateDTO;
        }).collect(Collectors.toList());
        for (UserPurseUpdateDTO ii2 : userPurseUpdateDTOS) {
            this.userPurseMapper.updatePoints(ii2);
        }
    }
}

