/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bcxin.tenant.open.domains.criterias.PoliceIncidentRegionReportCriteria;
import com.bcxin.tenant.open.domains.criterias.PoliceIncidentSearchCriteria;
import com.bcxin.tenant.open.domains.criterias.PoliceIncidentsSearchCriteria;
import com.bcxin.tenant.open.domains.dtos.PoliceIncidentPendingStatisticsDTO;
import com.bcxin.tenant.open.domains.dtos.PoliceIncidentRegionReportDTO;
import com.bcxin.tenant.open.domains.dtos.PoliceIncidentsSosUpdateDTO;
import com.bcxin.tenant.open.domains.entities.PoliceIncidentsEntity;
import com.bcxin.tenant.open.domains.mappers.PoliceIncidentsMapper;
import com.bcxin.tenant.open.domains.repositories.PoliceIncidentsRepository;
import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.infrastructures.enums.ResourceType;
import com.bcxin.tenant.open.infrastructures.repositories.RepositoryBaseAbstract;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Repository
public class PoliceIncidentsRepositoryImpl
extends RepositoryBaseAbstract
implements PoliceIncidentsRepository {
    private final PoliceIncidentsMapper policeIncidentsMapper;

    public PoliceIncidentsRepositoryImpl(PoliceIncidentsMapper policeIncidentsMapper) {
        this.policeIncidentsMapper = policeIncidentsMapper;
    }

    public PoliceIncidentsEntity getById(Object id) {
        return (PoliceIncidentsEntity)this.policeIncidentsMapper.selectById((Long)id);
    }

    public void insert(PoliceIncidentsEntity data) {
        this.policeIncidentsMapper.insert(data);
    }

    public void update(PoliceIncidentsEntity data) {
        this.policeIncidentsMapper.updateById(data);
    }

    public EntityCollection<PoliceIncidentsEntity> search(PoliceIncidentsSearchCriteria criteria) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (!CollectionUtils.isEmpty((Collection)criteria.getSuperviseDepartIds())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.in(PoliceIncidentsEntity::getSuperviseDepartId, criteria.getSuperviseDepartIds());
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getCategories())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.in(PoliceIncidentsEntity::getCategory, (Collection)criteria.getCategories().stream().map(ii -> ii.ordinal()).collect(Collectors.toList()));
        }
        if (criteria.getLevel() != null) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.eq(PoliceIncidentsEntity::getPoliceEventLevel, (Object)criteria.getLevel().ordinal());
        }
        if (criteria.getStatus() != null) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.eq(PoliceIncidentsEntity::getPoliceEventStatus, (Object)criteria.getStatus().ordinal());
        }
        Page page = new Page((long)criteria.getPageIndex(), (long)criteria.getPageSize());
        IPage policeIncidentsEntityIPage = this.policeIncidentsMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return EntityCollection.create((Collection)policeIncidentsEntityIPage.getRecords(), (int)criteria.getPageSize(), (Long)policeIncidentsEntityIPage.getTotal());
    }

    public void updateSsoStatus(PoliceIncidentsSosUpdateDTO data) {
        this.policeIncidentsMapper.updateSsoStatus(data);
    }

    public EntityCollection<PoliceIncidentsEntity> search(PoliceIncidentSearchCriteria criteria) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (!CollectionUtils.isEmpty((Collection)criteria.getSuperDepartIds())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.in(PoliceIncidentsEntity::getSuperviseDepartId, criteria.getSuperDepartIds());
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getCategories())) {
            Collection categories = criteria.getCategories().stream().map(ii -> ii.ordinal()).collect(Collectors.toList());
            queryWrapper = (LambdaQueryWrapper)queryWrapper.in(PoliceIncidentsEntity::getCategory, categories);
        }
        if (!criteria.isSupervise()) {
            queryWrapper = CollectionUtils.isEmpty((Collection)criteria.getOtherSpecialPermissionScopeIds()) ? (!CollectionUtils.isEmpty((Collection)criteria.getManagedProjectIds()) ? (LambdaQueryWrapper)queryWrapper.and(wrapper -> wrapper.in(PoliceIncidentsEntity::getProjectId, criteria.getManagedProjectIds())) : (LambdaQueryWrapper)queryWrapper.in(PoliceIncidentsEntity::getOrganizationId, criteria.getOrganizationIds())) : (!CollectionUtils.isEmpty((Collection)criteria.getManagedProjectIds()) ? (LambdaQueryWrapper)queryWrapper.and(wrapper -> ((LambdaQueryWrapper)wrapper.in(PoliceIncidentsEntity::getProjectId, criteria.getManagedProjectIds())).in(PoliceIncidentsEntity::getSecurityStationId, criteria.getOtherSpecialPermissionScopeIds())) : (LambdaQueryWrapper)queryWrapper.and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.in(PoliceIncidentsEntity::getOrganizationId, criteria.getOrganizationIds())).or()).in(PoliceIncidentsEntity::getSecurityStationId, criteria.getOtherSpecialPermissionScopeIds())));
        }
        if (StringUtils.hasLength((String)criteria.getEmployeeId())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.eq(PoliceIncidentsEntity::getTenantEmployeeId, (Object)criteria.getEmployeeId());
        }
        if (criteria.getBeginTime() != null) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.ge(PoliceIncidentsEntity::getCreatedTime, (Object)criteria.getBeginTime());
        }
        if (criteria.getEndTime() != null) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.le(PoliceIncidentsEntity::getCreatedTime, (Object)criteria.getEndTime());
        }
        if (StringUtils.hasLength((String)criteria.getOrganizationName())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.likeLeft(PoliceIncidentsEntity::getOrganizationName, (Object)criteria.getOrganizationName().concat("%"));
        }
        if (StringUtils.hasLength((String)criteria.getPoliceName())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.likeLeft(PoliceIncidentsEntity::getName, (Object)criteria.getPoliceName().trim().concat("%"));
        }
        if (StringUtils.hasLength((String)criteria.getReason())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.likeLeft(PoliceIncidentsEntity::getReason, (Object)criteria.getReason().trim().concat("%"));
        }
        if (StringUtils.hasLength((String)criteria.getEmpIdNumber())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.likeLeft(PoliceIncidentsEntity::getEmpIdNumber, (Object)criteria.getEmpIdNumber().trim().concat("%"));
        }
        if (StringUtils.hasLength((String)criteria.getContact())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.likeLeft(PoliceIncidentsEntity::getContact, (Object)criteria.getContact().trim().concat("%"));
        }
        if (StringUtils.hasLength((String)criteria.getStationName())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.likeLeft(PoliceIncidentsEntity::getSecurityStationName, (Object)criteria.getStationName().trim().concat("%"));
        }
        if (StringUtils.hasLength((String)criteria.getProcessorName())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.likeLeft(PoliceIncidentsEntity::getProcessedUserName, (Object)criteria.getProcessorName().trim().concat("%"));
        }
        if (criteria.getEventType() != null) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.eq(PoliceIncidentsEntity::getPoliceEventType, (Object)criteria.getEventType());
        }
        if (criteria.getLevel() != null) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.eq(PoliceIncidentsEntity::getPoliceEventLevel, (Object)criteria.getLevel().ordinal());
        }
        if (criteria.getStatus() != null) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.eq(PoliceIncidentsEntity::getPoliceEventStatus, (Object)criteria.getStatus().ordinal());
        }
        if (criteria.getBeginProcessedTime() != null) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.ge(PoliceIncidentsEntity::getProcessedTime, (Object)criteria.getBeginProcessedTime());
        }
        if (criteria.getEndProcessedTime() != null) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.le(PoliceIncidentsEntity::getProcessedTime, (Object)criteria.getEndProcessedTime());
        }
        if (StringUtils.hasLength((String)criteria.getEmpName())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.likeLeft(PoliceIncidentsEntity::getEmpName, (Object)criteria.getEmpName().trim().concat("%"));
        }
        if (StringUtils.hasLength((String)criteria.getProjectName())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.likeLeft(PoliceIncidentsEntity::getProjectName, (Object)criteria.getProjectName().trim().concat("%"));
        }
        if (StringUtils.hasLength((String)criteria.getRegionName())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.apply(String.format(" extend_json_info->'$.regionName'='%s'", criteria.getRegionName().replace("'", "''")), new Object[0]);
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getManagedProjectIds()) && criteria.getDeskTypes() != null) {
            int calculatedResourceTypeValue = ResourceType.getCalculatedResourceValueByDeskTypes((Collection)criteria.getDeskTypes());
            queryWrapper = (LambdaQueryWrapper)queryWrapper.apply("calculated_resource_type&" + calculatedResourceTypeValue + ">0", new Object[0]);
        }
        queryWrapper = (LambdaQueryWrapper)queryWrapper.orderByDesc(PoliceIncidentsEntity::getCreatedTime);
        if (!criteria.ignorePage()) {
            Page page = new Page((long)criteria.getPageIndex(), (long)criteria.getPageSize());
            IPage policeIncidentsEntityIPage = this.policeIncidentsMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
            return EntityCollection.create((Collection)policeIncidentsEntityIPage.getRecords(), (int)((int)page.getSize()), (Long)policeIncidentsEntityIPage.getTotal());
        }
        queryWrapper = (LambdaQueryWrapper)queryWrapper.last(String.format("limit %s, %s ", criteria.getSkip(), criteria.getPageSize()));
        List policeIncidentsEntityIPage = this.policeIncidentsMapper.selectList((Wrapper)queryWrapper);
        return EntityCollection.createForNoTotalCount((Collection)policeIncidentsEntityIPage, (int)criteria.getPageSize());
    }

    public Collection<PoliceIncidentPendingStatisticsDTO> getPendingTotal(Collection<String> superviseDepartIds) {
        if (CollectionUtils.isEmpty(superviseDepartIds)) {
            return Collections.EMPTY_LIST;
        }
        return this.policeIncidentsMapper.getPendingTotal(superviseDepartIds);
    }

    public void delete(PoliceIncidentsEntity data) {
        this.policeIncidentsMapper.deleteById(data);
    }

    public Collection<PoliceIncidentRegionReportDTO> getReport(PoliceIncidentRegionReportCriteria criteria) {
        if (!StringUtils.hasLength((String)criteria.getRegionName())) {
            return Collections.EMPTY_LIST;
        }
        return this.policeIncidentsMapper.getReport(criteria);
    }
}

