/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bcxin.tenant.open.domains.criterias.RollCallEmployeeCriteria;
import com.bcxin.tenant.open.domains.criterias.RollCallEmployeeGroupCriteria;
import com.bcxin.tenant.open.domains.dtos.RollCallEmployeeGroupSearchDTO;
import com.bcxin.tenant.open.domains.entities.RollCallEmployeeEntity;
import com.bcxin.tenant.open.domains.mappers.RollCallEmployeeMapper;
import com.bcxin.tenant.open.domains.repositories.RollCallEmployeeRepository;
import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.infrastructures.enums.RollCallStatus;
import com.bcxin.tenant.open.infrastructures.enums.RollCallType;
import com.bcxin.tenant.open.infrastructures.exceptions.NoAllowedTenantException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Repository
public class RollCallEmployeeRepositoryImpl
implements RollCallEmployeeRepository {
    private final RollCallEmployeeMapper rollCallEmployeeMapper;

    public RollCallEmployeeRepositoryImpl(RollCallEmployeeMapper rollCallEmployeeMapper) {
        this.rollCallEmployeeMapper = rollCallEmployeeMapper;
    }

    public RollCallEmployeeEntity getById(Object id) {
        return (RollCallEmployeeEntity)this.rollCallEmployeeMapper.selectById((Long)id);
    }

    public void insert(RollCallEmployeeEntity data) {
        this.rollCallEmployeeMapper.insert(data);
    }

    public void update(RollCallEmployeeEntity data) {
        this.rollCallEmployeeMapper.updateById(data);
    }

    public void batchInsert(Collection<RollCallEmployeeEntity> data) {
        for (RollCallEmployeeEntity ee : data) {
            this.rollCallEmployeeMapper.insert(ee);
        }
    }

    public Collection<RollCallEmployeeEntity> findByRollCallIdAndEmployeeIds(Long rollCallId, Collection<String> employeeIds) {
        if (CollectionUtils.isEmpty(employeeIds) || rollCallId == null) {
            return Collections.EMPTY_LIST;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.eq(RollCallEmployeeEntity::getRollCallId, (Object)rollCallId);
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.in(RollCallEmployeeEntity::getCalledEmployeeId, employeeIds);
        return this.rollCallEmployeeMapper.selectList((Wrapper)lambdaQueryWrapper);
    }

    public EntityCollection<RollCallEmployeeGroupSearchDTO> search(RollCallEmployeeGroupCriteria criteria) {
        Collection<RollCallEmployeeGroupSearchDTO> data = this.rollCallEmployeeMapper.searchByGroup(criteria);
        long totalCount = this.rollCallEmployeeMapper.getCountOfSearchByGroup(criteria);
        return EntityCollection.create(data, (int)criteria.getPageSize(), (Long)totalCount);
    }

    public Collection<RollCallEmployeeEntity> search(RollCallEmployeeCriteria criteria) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        if (StringUtils.hasLength((String)criteria.getCalledEmployeeId())) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.eq(RollCallEmployeeEntity::getCalledEmployeeId, (Object)criteria.getCalledEmployeeId());
        }
        if (StringUtils.hasLength((String)criteria.getRollCallId())) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.eq(RollCallEmployeeEntity::getRollCallId, (Object)criteria.getRollCallId());
        }
        if (criteria.getBeginDate() != null) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.ge(RollCallEmployeeEntity::getCreatedTime, (Object)criteria.getBeginDate());
        }
        if (StringUtils.hasLength((String)criteria.getActionOrganizationId())) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.eq(RollCallEmployeeEntity::getActionOrganizationId, (Object)criteria.getActionOrganizationId());
        }
        if (StringUtils.hasLength((String)criteria.getSecurityStationId())) {
            String stationId = criteria.getSecurityStationId().replace("'", "");
            String stationIdWhere = " security_station_json->'$.id'='" + stationId + "'";
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.apply(stationIdWhere, new Object[0]);
        }
        if (criteria.getEndDate() != null) {
            Date endDate = criteria.getEndDate();
            Calendar endDateCalender = Calendar.getInstance();
            endDateCalender.setTime(endDate);
            endDateCalender.add(5, 1);
            endDate = endDateCalender.getTime();
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.lt(RollCallEmployeeEntity::getCreatedTime, (Object)endDate);
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getCallStatuses())) {
            int callStatusValue = RollCallStatus.calculate((Collection)criteria.getCallStatuses());
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.apply("`status` & " + callStatusValue + ">0", new Object[0]);
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getCallTypes())) {
            int callTypeValue = RollCallType.calculate((Collection)criteria.getCallTypes());
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.apply("`call_type` & " + callTypeValue + ">0", new Object[0]);
        }
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.last(String.format("limit %s,%s", criteria.getSkip(), criteria.getPageSize()));
        List data = this.rollCallEmployeeMapper.selectList((Wrapper)lambdaQueryWrapper);
        return data;
    }

    public Collection<RollCallEmployeeEntity> getTopNCanBeExpiredRecords(int pageSize, RollCallStatus callStatus) {
        if (callStatus != RollCallStatus.RollCallInit && callStatus != RollCallStatus.DispatchInit) {
            throw new NoAllowedTenantException();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        Calendar currentCalendar = Calendar.getInstance();
        int seconds = 180;
        seconds = callStatus == RollCallStatus.RollCallInit ? 180 : 66;
        currentCalendar.add(13, 0 - seconds);
        Date shouldBeExpiredTime = currentCalendar.getTime();
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.le(RollCallEmployeeEntity::getLastActionTime, (Object)shouldBeExpiredTime);
        Collection selectedRollCallStatuses = Stream.of(callStatus).collect(Collectors.toList());
        int calculatedRollCallStatus = RollCallStatus.calculate((Collection)selectedRollCallStatuses);
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.apply("status & " + calculatedRollCallStatus + " > 0", new Object[0]);
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.last(String.format("limit %s", pageSize));
        return this.rollCallEmployeeMapper.selectList((Wrapper)lambdaQueryWrapper);
    }

    public Collection<RollCallEmployeeEntity> findByIds(Collection<String> ids) {
        return this.rollCallEmployeeMapper.selectBatchIds(ids);
    }

    public Collection<RollCallEmployeeEntity> findByRollCallIdsAndEmployeeIds(Collection<Long> rollCallIds, Collection<String> employeeIds) {
        if (CollectionUtils.isEmpty(employeeIds) || CollectionUtils.isEmpty(rollCallIds)) {
            return Collections.EMPTY_LIST;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.in(RollCallEmployeeEntity::getRollCallId, rollCallIds);
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.in(RollCallEmployeeEntity::getCalledEmployeeId, employeeIds);
        return this.rollCallEmployeeMapper.selectList((Wrapper)lambdaQueryWrapper);
    }

    public void batchUpdateStatusAndCId(Collection<RollCallEmployeeEntity> data) {
        this.rollCallEmployeeMapper.batchUpdateStatusAndCId(data);
    }
}

