/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.bcxin.tenant.open.domains.entities.MonthlyBillEntity;
import com.bcxin.tenant.open.domains.mappers.MonthlyBillMapper;
import com.bcxin.tenant.open.domains.repositories.MonthlyBillRepository;
import com.bcxin.tenant.open.infrastructures.enums.BillPaymentStatus;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class MonthlyBillRepositoryImpl
implements MonthlyBillRepository {
    private final MonthlyBillMapper billMapper;

    public MonthlyBillRepositoryImpl(MonthlyBillMapper billMapper) {
        this.billMapper = billMapper;
    }

    public MonthlyBillEntity getById(Object id) {
        return null;
    }

    public void insert(MonthlyBillEntity data) {
    }

    public void update(MonthlyBillEntity data) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(MonthlyBillEntity::getBillId, (Object)data.getBillId());
        this.billMapper.update(data, (Wrapper)updateWrapper);
    }

    public void generateBills(List<MonthlyBillEntity> billEntityList) {
        this.billMapper.generateBills(billEntityList);
    }

    public void updatePayment(String billId, Integer paidAmount) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(MonthlyBillEntity::getPaidAmount, (Object)paidAmount)).set(MonthlyBillEntity::getPaidTime, (Object)Timestamp.from(Instant.now()))).eq(MonthlyBillEntity::getBillId, (Object)billId);
        this.billMapper.update(null, (Wrapper)updateWrapper);
    }

    public void insertEmptyBills(List<MonthlyBillEntity> billEntityList) {
        if (billEntityList.isEmpty()) {
            return;
        }
        this.billMapper.insertEmptyBills(billEntityList);
    }

    public List<MonthlyBillEntity> getByBillId(List<String> billIds) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(MonthlyBillEntity::getBillId, billIds);
        return this.billMapper.selectList((Wrapper)queryWrapper);
    }

    public List<MonthlyBillEntity> getRequiredPaymentBillsByMonth(String month) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(MonthlyBillEntity::getMonth, (Object)month);
        queryWrapper.eq(MonthlyBillEntity::getIsReady, (Object)1);
        queryWrapper.in(MonthlyBillEntity::getBillPaymentStatus, new Object[]{BillPaymentStatus.Unpaid.ordinal(), BillPaymentStatus.PartialPaid.ordinal()});
        return this.billMapper.selectList((Wrapper)queryWrapper);
    }

    public List<MonthlyBillEntity> getRequiredPaymentBills() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(MonthlyBillEntity::getIsReady, (Object)1);
        queryWrapper.in(MonthlyBillEntity::getBillPaymentStatus, new Object[]{BillPaymentStatus.Unpaid.ordinal(), BillPaymentStatus.PartialPaid.ordinal()});
        return this.billMapper.selectList((Wrapper)queryWrapper);
    }

    public List<MonthlyBillEntity> getRequiredPaymentBillsByOrgs(Collection<String> orgIds) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(MonthlyBillEntity::getOrgId, orgIds);
        queryWrapper.eq(MonthlyBillEntity::getIsReady, (Object)1);
        queryWrapper.in(MonthlyBillEntity::getBillPaymentStatus, new Object[]{BillPaymentStatus.Unpaid.ordinal(), BillPaymentStatus.PartialPaid.ordinal()});
        return this.billMapper.selectList((Wrapper)queryWrapper);
    }

    public void updatePaidAmount(List<MonthlyBillEntity> billEntityList) {
        if (billEntityList.isEmpty()) {
            return;
        }
        this.billMapper.updatePaidAmount(billEntityList);
    }
}

