/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.document.domains.utils;

import com.bcxin.tenant.open.document.domains.documents.RdEmployeeDocument;
import com.bcxin.tenant.open.document.domains.documents.RdEmployeeDocument$;
import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument;
import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument$;
import com.bcxin.tenant.open.infrastructures.enums.RoleType;
import com.bcxin.tenant.open.infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.tenant.open.infrastructures.utils.BusinessUtil;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.redis.om.spring.search.stream.SearchStream;
import com.redis.om.spring.search.stream.predicates.SearchFieldPredicate;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class DocumentScopeFilterUtils {
    public static SearchStream<RdEmployeeDocument> basicFilterEmployee(SearchStream<RdEmployeeDocument> documentSearchStream, String orgInstitutional, String orgId, String orgName, Collection<String> superviseDepartIds) {
        if (BusinessUtil.isSupervise((String)orgInstitutional)) {
            if (CollectionUtils.isEmpty(superviseDepartIds)) {
                throw new ArgumentTenantException("\u76d1\u7ba1\u7ec4\u7ec7-\u76d1\u7ba1\u7684\u8c03\u5ea6\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String[] scopeIds = (String[])superviseDepartIds.toArray(String[]::new);
            documentSearchStream = documentSearchStream.filter((SearchFieldPredicate)RdEmployeeDocument$.SCOPE_PERMISSIONS.in(scopeIds));
        } else {
            if (StringUtil.isEmpty((String)orgId)) {
                throw new ArgumentTenantException("\u4f01\u4e1a\u7ec4\u7ec7-\u7ec4\u7ec7Id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            documentSearchStream = documentSearchStream.filter((SearchFieldPredicate)RdEmployeeDocument$.SCOPE_PERMISSIONS.in(new String[]{orgId}));
            RoleType roleType = RoleType.create((String)orgInstitutional, (String)orgName);
            if (roleType == RoleType.Company) {
                String[] excludeValues = new String[]{"#1"};
                documentSearchStream = documentSearchStream.filter((SearchFieldPredicate)RdEmployeeDocument$.SECURITY_STATION_ID.notEq(excludeValues));
            }
        }
        return documentSearchStream;
    }

    public static SearchStream<RdSecurityStationDocument> basicFilterStation(SearchStream<RdSecurityStationDocument> documentSearchStream, String orgInstitutional, String orgId, Collection<String> superviseDepartIds) {
        if (BusinessUtil.isSupervise((String)orgInstitutional)) {
            if (CollectionUtils.isEmpty(superviseDepartIds)) {
                throw new ArgumentTenantException("\u76d1\u7ba1\u7ec4\u7ec7-\u76d1\u7ba1\u7684\u8c03\u5ea6\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String[] scopeIds = (String[])superviseDepartIds.toArray(String[]::new);
            documentSearchStream = documentSearchStream.filter((SearchFieldPredicate)RdSecurityStationDocument$.SCOPE_PERMISSIONS.in(scopeIds));
        } else {
            if (StringUtil.isEmpty((String)orgId)) {
                throw new ArgumentTenantException("\u4f01\u4e1a\u7ec4\u7ec7-\u7ec4\u7ec7Id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            documentSearchStream = documentSearchStream.filter((SearchFieldPredicate)RdSecurityStationDocument$.SCOPE_PERMISSIONS.in(new String[]{orgId}));
        }
        return documentSearchStream;
    }
}

