package com.bcxin.tenant.flink.job;

import com.bcxin.flink.core.CoreJobContext;
import com.bcxin.flink.core.properties.CheckpointConfigProperty;
import lombok.Getter;

import java.io.Serializable;

@Getter
public class StreamingJobContext implements CoreJobContext,Serializable {
    private final String name;

    private StreamingJobContext(
            String name,
            CheckpointConfigProperty configProperty) {
        this.name = name;
        this.configProperty = configProperty;
    }

    private final CheckpointConfigProperty configProperty;

    private static StreamingJobContext _instance;
    public static void init(
            String name,
            CheckpointConfigProperty configProperty) {
        if (_instance == null) {
            synchronized (StreamingJobContext.class) {
                if (_instance == null) {
                    _instance = new StreamingJobContext(name, configProperty);
                }
            }
        }
    }

    public static StreamingJobContext getInstance() {

        if (_instance == null) {
            throw new IllegalArgumentException("未对StreamingJobContext进行初始化操作");
        }

        return _instance;
    }
}
