/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.flink.job.definitions;

import com.bcxin.tenant.open.infrastructures.flinks.FlinkDefinitionAbstract;
import java.util.Collection;

public class JdbcMetaDefinition
extends FlinkDefinitionAbstract {
    private String url;
    private String userName;
    private String password;
    private Collection<JdbcMetaSqlDefinition> sqlMetaDefinitions;

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public Collection<JdbcMetaSqlDefinition> getSqlMetaDefinitions() {
        return this.sqlMetaDefinitions;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSqlMetaDefinitions(Collection<JdbcMetaSqlDefinition> sqlMetaDefinitions) {
        this.sqlMetaDefinitions = sqlMetaDefinitions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcMetaDefinition)) {
            return false;
        }
        JdbcMetaDefinition other = (JdbcMetaDefinition)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Collection<JdbcMetaSqlDefinition> this$sqlMetaDefinitions = this.getSqlMetaDefinitions();
        Collection<JdbcMetaSqlDefinition> other$sqlMetaDefinitions = other.getSqlMetaDefinitions();
        return !(this$sqlMetaDefinitions == null ? other$sqlMetaDefinitions != null : !((Object)this$sqlMetaDefinitions).equals(other$sqlMetaDefinitions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcMetaDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Collection<JdbcMetaSqlDefinition> $sqlMetaDefinitions = this.getSqlMetaDefinitions();
        result = result * 59 + ($sqlMetaDefinitions == null ? 43 : ((Object)$sqlMetaDefinitions).hashCode());
        return result;
    }

    public String toString() {
        return "JdbcMetaDefinition(url=" + this.getUrl() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", sqlMetaDefinitions=" + this.getSqlMetaDefinitions() + ")";
    }

    public static class JdbcMetaSqlDefinition
    extends FlinkDefinitionAbstract {
        private String tableName;
        private String sql;

        public String getFullSql(JdbcMetaDefinition definition) {
            String withJdbcPropertyFormat = " WITH ('connector'='jdbc','url'='%s','table-name'='%s','username'='%s','password'='%s','sink.parallelism'='1')";
            return this.getSql().concat(String.format(withJdbcPropertyFormat, definition.getUrl(), this.getTableName(), definition.getUserName(), definition.getPassword()));
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getSql() {
            return this.sql;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JdbcMetaSqlDefinition)) {
                return false;
            }
            JdbcMetaSqlDefinition other = (JdbcMetaSqlDefinition)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            String this$tableName = this.getTableName();
            String other$tableName = other.getTableName();
            if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
                return false;
            }
            String this$sql = this.getSql();
            String other$sql = other.getSql();
            return !(this$sql == null ? other$sql != null : !this$sql.equals(other$sql));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JdbcMetaSqlDefinition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tableName = this.getTableName();
            result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
            String $sql = this.getSql();
            result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
            return result;
        }

        public String toString() {
            return "JdbcMetaDefinition.JdbcMetaSqlDefinition(tableName=" + this.getTableName() + ", sql=" + this.getSql() + ")";
        }
    }
}

