/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.core.properties.impls;

import com.bcxin.flink.core.properties.CheckpointConfigProperty;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskCheckpointConfigPropertyImpl
implements CheckpointConfigProperty {
    private static final Logger logger = LoggerFactory.getLogger(DiskCheckpointConfigPropertyImpl.class);
    private String checkPointLocation;
    private String lastCheckpointPath;

    @Override
    public String getSavepointPath() {
        if (StringUtils.isEmpty((CharSequence)this.getLastCheckpointPath())) {
            return null;
        }
        return String.format("file:///%s", this.getLastCheckpointPath());
    }

    @Override
    public String getCheckpointPath() {
        if (StringUtils.isEmpty((CharSequence)this.getCheckPointLocation())) {
            throw new BadTenantException("Disk\u7684checkpoint\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return String.format("file:///%s", this.getCheckPointLocation());
    }

    private DiskCheckpointConfigPropertyImpl() {
    }

    public static DiskCheckpointConfigPropertyImpl create(String checkPointLocation) {
        File[] subDirs;
        DiskCheckpointConfigPropertyImpl property = new DiskCheckpointConfigPropertyImpl();
        property.setCheckPointLocation(checkPointLocation);
        File checkPointDir = FileUtils.getFile((String[])new String[]{checkPointLocation});
        if (checkPointDir == null) {
            return property;
        }
        if (!checkPointDir.exists()) {
            try {
                FileUtils.forceMkdir((File)checkPointDir);
            }
            catch (IOException e) {
                logger.error(String.format("\u5f3a\u5236\u521b\u5efa\u76ee\u5f55\u53d1\u751f\u5f02\u5e38:%s", checkPointDir), (Throwable)e);
                e.printStackTrace();
            }
        }
        if ((subDirs = checkPointDir.listFiles(ii -> ii.isDirectory())) != null) {
            for (File sd : subDirs) {
                logger.info("\u5f53\u524dcheckpoint\u7684\u5b50\u76ee\u5f55\u4e3a={};", (Object)sd.getPath());
                logger.info("\u5f53\u524dcheckpoint\u7684\u5b50\u76ee\u5f55\u7684\u5b50\u8282\u70b9\u4e3a={};", (Object)Arrays.stream(sd.listFiles()).map(ix -> ix.getPath()).collect(Collectors.joining(";")));
            }
            Collection allCheckpointFiles = Arrays.stream(subDirs).filter(ii -> Arrays.stream(ii.listFiles()).anyMatch(ix -> ix.getName().startsWith("chk") && Arrays.stream(ix.listFiles()).anyMatch(ic -> ic.getName().equalsIgnoreCase("_metadata")))).collect(Collectors.toList());
            Optional lastCheckpointDirOptional = allCheckpointFiles.stream().sorted((i1, i2) -> i1.lastModified() > i2.lastModified() ? -1 : 1).findFirst();
            logger.info("\u4e0a\u6b21checkpoint\u7684\u76ee\u5f55\u4f4d\u7f6e={};", (Object)(lastCheckpointDirOptional.isPresent() ? ((File)lastCheckpointDirOptional.get()).getPath() : "\u65e0"));
            if (lastCheckpointDirOptional.isPresent()) {
                File lastCheckpointDir = (File)lastCheckpointDirOptional.get();
                Optional<File> checkDirOptional = Arrays.stream(lastCheckpointDir.listFiles(ii -> ii.getName().startsWith("chk") && Arrays.stream(ii.listFiles(ix -> ix.getName().equalsIgnoreCase("_metadata"))).count() > 0L)).findFirst();
                logger.info("\u4e0a\u6b21checkpoint\u7684\u6587\u4ef6\u4f4d\u7f6e={}", (Object)(checkDirOptional.isPresent() ? checkDirOptional.get().getPath() : "\u65e0"));
                if (!checkDirOptional.isPresent()) {
                    throw new IllegalArgumentException(String.format("\u975e\u9884\u671f\u5f02\u5e38; \u4e0d\u5e94\u8be5\u627e\u4e0d\u5230\u524d\u4e00\u4e2aSavePoint\u70b9\u7684\u6709\u6548\u8def\u5f84(%s)", lastCheckpointDir.getPath()));
                }
                property.setLastCheckpointPath(checkDirOptional.get().getPath());
            }
        } else {
            logger.info("\u5f53\u524dcheckpoint({})\u7684\u5b50\u76ee\u5f55\u4e3a=\u7a7a;", (Object)checkPointDir.getPath());
        }
        return property;
    }

    private String getCheckPointLocation() {
        return this.checkPointLocation;
    }

    private String getLastCheckpointPath() {
        return this.lastCheckpointPath;
    }

    private void setCheckPointLocation(String checkPointLocation) {
        this.checkPointLocation = checkPointLocation;
    }

    private void setLastCheckpointPath(String lastCheckpointPath) {
        this.lastCheckpointPath = lastCheckpointPath;
    }
}

