/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.bcxin.tenant.open.domains.entities.DailyBillEntity;
import com.bcxin.tenant.open.domains.mappers.DailyBillMapper;
import com.bcxin.tenant.open.domains.pojo.DailyBillPojo;
import com.bcxin.tenant.open.domains.pojo.MonthBillPojo;
import com.bcxin.tenant.open.domains.repositories.DailyBillRepository;
import com.bcxin.tenant.open.infrastructures.enums.BillType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class DailyBillRepositoryImpl
implements DailyBillRepository {
    private DailyBillMapper billMapper;

    public DailyBillRepositoryImpl(DailyBillMapper billMapper) {
        this.billMapper = billMapper;
    }

    public DailyBillEntity getById(Object id) {
        return null;
    }

    public void insert(DailyBillEntity billEntity) {
        this.billMapper.insert(billEntity);
    }

    public void update(DailyBillEntity data) {
    }

    public void insert(List<DailyBillEntity> dailyBillEntityList) {
        this.billMapper.insertList(dailyBillEntityList);
    }

    public List<MonthBillPojo> calcMonthBill(String date, BillType type) {
        return this.billMapper.calcMonthBill(date, type.ordinal());
    }

    public List<DailyBillPojo> getAttendanceBillInfo(String orgId, Date fromDate, Date endDate) {
        return this.billMapper.getAttendanceBillInfo(orgId, fromDate == null ? null : new SimpleDateFormat("yyyy-MM-dd 00:00:00").format(fromDate), new SimpleDateFormat("yyyy-MM-dd 23:59:59").format(endDate));
    }

    public List<DailyBillPojo> getRollCallBillInfo(String orgId, Date fromDate, Date endDate) {
        return this.billMapper.getRollCallBillInfo(orgId, fromDate == null ? null : new SimpleDateFormat("yyyy-MM-dd 00:00:00").format(fromDate), new SimpleDateFormat("yyyy-MM-dd 23:59:59").format(endDate));
    }

    public List<DailyBillPojo> getEmployeeLocationBillInfo(String orgId, Date fromDate, Date endDate) {
        return this.billMapper.getEmployeeLocationBillInfo(orgId, fromDate == null ? null : new SimpleDateFormat("yyyy-MM-dd 00:00:00").format(fromDate), new SimpleDateFormat("yyyy-MM-dd 23:59:59").format(endDate));
    }

    public List<DailyBillPojo> getSecurityStationRailBillInfo(String orgId, Date fromDate, Date endDate) {
        return this.billMapper.getSecurityStationRailBillInfo(orgId, fromDate == null ? null : new SimpleDateFormat("yyyy-MM-dd 00:00:00").format(fromDate), new SimpleDateFormat("yyyy-MM-dd 23:59:59").format(endDate));
    }

    public List<MonthBillPojo> calcMonthBillRange(String orgId, BillType type, Date fromDate, Date endDate) {
        return this.billMapper.calcMonthBillByRange(orgId, type.ordinal(), fromDate == null ? null : new SimpleDateFormat("yyyy-MM-dd 00:00:00").format(fromDate), new SimpleDateFormat("yyyy-MM-dd 23:59:59").format(endDate));
    }
}

