/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.core.properties.impls;

import com.bcxin.flink.core.properties.CheckpointConfigProperty;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsCheckpointConfigPropertyImpl
implements CheckpointConfigProperty {
    private final String baseSite;
    private final String contextPath;
    private String lastCheckpointPath;

    private HdfsCheckpointConfigPropertyImpl(String baseSite, String contextPath) {
        this.baseSite = baseSite;
        this.contextPath = contextPath;
    }

    @Override
    public String getSavepointPath() {
        return this.getCheckpointPath();
    }

    @Override
    public String getCheckpointPath() {
        return this.getBaseSite().concat(this.getContextPath());
    }

    public static HdfsCheckpointConfigPropertyImpl create(Configuration conf, String baseSite, String contextPath) throws IOException {
        Optional<FileStatus> fileStatusOptional;
        HdfsCheckpointConfigPropertyImpl property = new HdfsCheckpointConfigPropertyImpl(baseSite, contextPath);
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] fileStatuses = fs.listStatus(new Path(contextPath));
        if (fileStatuses != null && (fileStatusOptional = Arrays.stream(fileStatuses).sorted((i1, i2) -> i1.getModificationTime() > i2.getModificationTime() ? 1 : 0).findFirst()).isPresent()) {
            FileStatus lastFileStatus = fileStatusOptional.get();
            Optional<FileStatus> lastCheckpointFileStatusOptional = Arrays.stream(fs.listStatus(new Path(contextPath.concat(File.separator).concat(lastFileStatus.getPath().getName())), ii -> {
                boolean flag = ii.getName().startsWith("chk");
                if (flag) {
                    try {
                        FileStatus[] subFileStatuses = fs.listStatus(ii);
                        flag = Arrays.stream(subFileStatuses).filter(ix -> ix.isFile()).anyMatch(ix -> ix.getPath().getName().equalsIgnoreCase("_metadata"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        flag = false;
                    }
                }
                return flag;
            })).findFirst();
            if (lastCheckpointFileStatusOptional.isPresent()) {
                FileStatus lastCheckpointFileStatus = lastCheckpointFileStatusOptional.get();
                property.setLastCheckpointPath(lastCheckpointFileStatus.getPath().toString());
            }
        }
        return property;
    }

    private String getBaseSite() {
        return this.baseSite;
    }

    private String getContextPath() {
        return this.contextPath;
    }

    private String getLastCheckpointPath() {
        return this.lastCheckpointPath;
    }

    private void setLastCheckpointPath(String lastCheckpointPath) {
        this.lastCheckpointPath = lastCheckpointPath;
    }
}

