/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.infrastructures.utils;

import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StringUtil {
    public static String[] chars = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    public static boolean isNumber(String value) {
        if (value == null) {
            return false;
        }
        if (value.length() >= 15) {
            value = value.substring(0, value.length() - 2);
        }
        return value.matches("\\d*");
    }

    public static String generateShortUuid() {
        StringBuffer shortBuffer = new StringBuffer();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        for (int i = 0; i < 8; ++i) {
            String str = uuid.substring(i * 4, i * 4 + 4);
            int x = Integer.parseInt(str, 16);
            shortBuffer.append(chars[x % 62]);
        }
        return shortBuffer.toString();
    }

    public static boolean isEmpty(String value1) {
        return value1 == null || value1.equals("");
    }

    public static String leftPad(String value, int num) {
        String res = String.format("%" + num + "s", value);
        res = res.replaceAll("\\s", "0");
        return res;
    }

    public static boolean isEqual(String a, String b) {
        if (StringUtil.isEmpty(a) && StringUtil.isEmpty(b)) {
            return true;
        }
        if (StringUtil.isEmpty(a) || StringUtil.isEmpty(b)) {
            return false;
        }
        return a.equalsIgnoreCase(b);
    }

    public static String formatFullText(String input, boolean deleted) {
        if (StringUtil.isEmpty(input)) {
            return input;
        }
        Collection specialValues = Stream.of("\\", "-", "@", "#", "$", "*", "+", "=", "/", "\"", "'", ".", "%", "&", "!", "(", ")", "[", "]", "{", "}", ",", ";", "^", "?", "<", ">", "|").collect(Collectors.toUnmodifiableList());
        for (String ix : specialValues) {
            if (deleted) {
                input = input.replace(ix, "");
                continue;
            }
            input = input.replace(ix, String.format("\\%s", ix));
        }
        if (!deleted) {
            input = input.replace(" ", "");
        }
        return input;
    }
}

