/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bcxin.tenant.open.domains.dtos.SecurityStationCountDTO;
import com.bcxin.tenant.open.domains.entities.RdSecurityStationPersonEntity;
import com.bcxin.tenant.open.domains.mappers.RdSecurityStationPersonMapper;
import com.bcxin.tenant.open.domains.repositories.RdSecurityStationPersonRepository;
import java.util.Collection;
import java.util.Collections;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class RdSecurityStationPersonRepositoryImpl
implements RdSecurityStationPersonRepository {
    private final RdSecurityStationPersonMapper securityStationPersonMapper;

    public RdSecurityStationPersonRepositoryImpl(RdSecurityStationPersonMapper securityStationPersonMapper) {
        this.securityStationPersonMapper = securityStationPersonMapper;
    }

    public RdSecurityStationPersonEntity getById(Object id) {
        return (RdSecurityStationPersonEntity)this.securityStationPersonMapper.selectById((Long)id);
    }

    public void insert(RdSecurityStationPersonEntity data) {
        this.securityStationPersonMapper.insert(data);
    }

    public void update(RdSecurityStationPersonEntity data) {
        this.securityStationPersonMapper.updateById(data);
    }

    public Collection<SecurityStationCountDTO> getCountOfPersonByStationIds(Collection<String> stationIds) {
        if (CollectionUtils.isEmpty(stationIds)) {
            return Collections.EMPTY_LIST;
        }
        return this.securityStationPersonMapper.countByStationIds(stationIds);
    }

    public void refreshEmployeeStationByEmployeeIds(Collection<String> employeeIds) {
        this.securityStationPersonMapper.refreshEmployeeStationByEmployeeIds(employeeIds);
    }

    public RdSecurityStationPersonEntity getByNoPkId(String id) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(RdSecurityStationPersonEntity::getId, (Object)id);
        return (RdSecurityStationPersonEntity)this.securityStationPersonMapper.selectOne((Wrapper)lambdaQueryWrapper);
    }
}

