/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.plugins;

import com.bcxin.tenant.open.infrastructures.components.RetryProvider;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.IgnoreTenantException;
import com.bcxin.tenant.open.infrastructures.utils.ExceptionUtil;
import java.sql.SQLIntegrityConstraintViolationException;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MybatisExecuteBatisPlugin
implements Interceptor {
    private final RetryProvider retryProvider;

    public MybatisExecuteBatisPlugin(RetryProvider retryProvider) {
        this.retryProvider = retryProvider;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        return this.retryProvider.doExecute(() -> {
            try {
                return invocation.proceed();
            }
            catch (Exception e) {
                if (e.getCause() != null && e.getCause().getClass().isAssignableFrom(SQLIntegrityConstraintViolationException.class)) {
                    throw new IgnoreTenantException("Mybatis\u6267\u884c\u5f02\u5e38", e);
                }
                if (ExceptionUtil.getStackMessage((Throwable)e).contains("Duplicate entry")) {
                    throw new IgnoreTenantException("Mybatis\u6267\u884c\u5f02\u5e38", e);
                }
                throw new BadTenantException(e.getMessage(), (Throwable)e);
            }
        });
    }
}

