/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bcxin.tenant.open.domains.entities.RdSecurityStationEntity;
import com.bcxin.tenant.open.domains.mappers.RdSecurityStationMapper;
import com.bcxin.tenant.open.domains.repositories.RdSecurityStationRepository;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class RdSecurityStationRepositoryImpl
implements RdSecurityStationRepository {
    private final RdSecurityStationMapper rdSecurityStationMapper;

    public RdSecurityStationRepositoryImpl(RdSecurityStationMapper rdSecurityStationMapper) {
        this.rdSecurityStationMapper = rdSecurityStationMapper;
    }

    public RdSecurityStationEntity getById(Object pkId) {
        long id = (Long)pkId;
        RdSecurityStationEntity stationEntity = (RdSecurityStationEntity)this.rdSecurityStationMapper.selectById(Long.valueOf(id));
        return stationEntity;
    }

    public void insert(RdSecurityStationEntity data) {
        this.rdSecurityStationMapper.insert(data);
    }

    public void update(RdSecurityStationEntity data) {
        this.rdSecurityStationMapper.updateById(data);
    }

    public Collection<RdSecurityStationEntity> getByPage(Collection<String> ids, int pageIndex, int pageSize) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (!CollectionUtils.isEmpty(ids)) {
            wrapper = (LambdaQueryWrapper)wrapper.in(RdSecurityStationEntity::getId, ids);
        }
        if (pageIndex <= 0) {
            pageIndex = 1;
        }
        Page page = new Page((long)pageIndex, (long)pageSize);
        IPage rdCompanyEntityPage = this.rdSecurityStationMapper.selectPage((IPage)page, (Wrapper)wrapper);
        return rdCompanyEntityPage.getRecords();
    }

    public void updateCountOfSecurityMen(Collection<String> stationIds) {
        this.rdSecurityStationMapper.updateCountOfSecurityMen(stationIds);
    }

    public RdSecurityStationEntity getByNoPkId(String id) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(RdSecurityStationEntity::getId, (Object)id);
        return (RdSecurityStationEntity)this.rdSecurityStationMapper.selectOne((Wrapper)lambdaQueryWrapper);
    }

    public Collection<RdSecurityStationEntity> getByIds(Collection<String> ids) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (!CollectionUtils.isEmpty(ids)) {
            wrapper = (LambdaQueryWrapper)wrapper.in(RdSecurityStationEntity::getId, ids);
        }
        return this.rdSecurityStationMapper.selectList((Wrapper)wrapper);
    }

    public Collection<String> getInvalidStationIds(int pageSize) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.notIn(RdSecurityStationEntity::getSiteState, new Object[]{"\u5df2\u5b8c\u5584", "\u751f\u6548"});
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.lt(RdSecurityStationEntity::getEndDate, (Object)calendar.getTime());
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.last(String.format("limit 0,%s", pageSize));
        lambdaQueryWrapper = lambdaQueryWrapper.select(new SFunction[]{RdSecurityStationEntity::getId});
        List maps = this.rdSecurityStationMapper.selectMaps((Wrapper)lambdaQueryWrapper);
        return maps.stream().map(ii -> String.valueOf(ii.get("id"))).collect(Collectors.toList());
    }
}

