/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.bcxin.tenant.open.domains.dtos.ProcessTencentCallbackLogDTO;
import com.bcxin.tenant.open.domains.entities.TencentCallbackLogEntity;
import com.bcxin.tenant.open.domains.mappers.TencentCallbackLogMapper;
import com.bcxin.tenant.open.domains.repositories.TencentCallbackLogRepository;
import com.bcxin.tenant.open.domains.views.TencentCallbackLogView;
import com.bcxin.tenant.open.infrastructures.exceptions.NotSupportTenantException;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class TencentCallbackLogRepositoryImpl
implements TencentCallbackLogRepository {
    private final TencentCallbackLogMapper tencentCallbackLogMapper;
    private final SqlSessionFactory sessionFactory;

    public TencentCallbackLogRepositoryImpl(TencentCallbackLogMapper tencentCallbackLogMapper, SqlSessionFactory sessionFactory) {
        this.tencentCallbackLogMapper = tencentCallbackLogMapper;
        this.sessionFactory = sessionFactory;
    }

    public TencentCallbackLogEntity getById(Object id) {
        return (TencentCallbackLogEntity)this.tencentCallbackLogMapper.selectById((Long)id);
    }

    public void insert(TencentCallbackLogEntity data) {
        this.tencentCallbackLogMapper.customInsert(data);
    }

    public void update(TencentCallbackLogEntity data) {
        throw new NotSupportTenantException("\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
    }

    public void batchInsert(Collection<TencentCallbackLogEntity> logs) {
        if (CollectionUtils.isEmpty(logs)) {
            return;
        }
        try (SqlSession session = this.sessionFactory.openSession(ExecutorType.BATCH, false);){
            TencentCallbackLogMapper mapper = (TencentCallbackLogMapper)session.getMapper(TencentCallbackLogMapper.class);
            for (TencentCallbackLogEntity log : logs) {
                mapper.customInsert(log);
            }
            session.commit();
        }
    }

    public Collection<String> getTopExitRoomButPendingIds(Collection<Long> exitRoomLogIds) {
        Collection<String> roomIds = this.tencentCallbackLogMapper.getTopExitRoomButPendingIds(exitRoomLogIds);
        if (CollectionUtils.isEmpty(roomIds)) {
            return Collections.EMPTY_LIST;
        }
        return roomIds.stream().distinct().collect(Collectors.toList());
    }

    public Collection<TencentCallbackLogView> getAllPendingLogsByRoomIds(Collection<Long> roomIds) {
        Collection<TencentCallbackLogView> callbackLogViews = this.tencentCallbackLogMapper.getAllPendingLogsByRoomIds(roomIds);
        return callbackLogViews;
    }

    public void process(ProcessTencentCallbackLogDTO callbackLogDTO) {
        this.tencentCallbackLogMapper.process(callbackLogDTO);
    }
}

