/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bcxin.tenant.open.domains.criterias.RollCallPlanSearchCriteria;
import com.bcxin.tenant.open.domains.entities.RollCallPlanEntity;
import com.bcxin.tenant.open.domains.mappers.RollCallPlanMapper;
import com.bcxin.tenant.open.domains.repositories.RollCallPlanRepository;
import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.infrastructures.enums.RepetitiveRule;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class RollCallPlanRepositoryImpl
implements RollCallPlanRepository {
    private final RollCallPlanMapper rollCallPlanMapper;

    public RollCallPlanRepositoryImpl(RollCallPlanMapper rollCallPlanMapper) {
        this.rollCallPlanMapper = rollCallPlanMapper;
    }

    public RollCallPlanEntity getById(Object id) {
        return (RollCallPlanEntity)this.rollCallPlanMapper.selectById((Long)id);
    }

    public void insert(RollCallPlanEntity data) {
        this.rollCallPlanMapper.insert(data);
    }

    public void update(RollCallPlanEntity data) {
        this.rollCallPlanMapper.updateById(data);
    }

    public EntityCollection<RollCallPlanEntity> search(RollCallPlanSearchCriteria criteria) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.eq(RollCallPlanEntity::isDeleted, (Object)false);
        if (StringUtils.hasLength((String)criteria.getName())) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.like(RollCallPlanEntity::getName, (Object)"%".concat(criteria.getName()).concat("%"));
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getSuperviseDepartIds())) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.in(RollCallPlanEntity::getSuperviseDepartId, criteria.getSuperviseDepartIds());
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getStationTypes())) {
            String filterValue = criteria.getStationTypes().stream().map(ii -> String.format("\"%s\"", ii)).distinct().collect(Collectors.joining(","));
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.apply("JSON_CONTAINS(station_types,'[" + filterValue + "]')", new Object[0]);
        }
        Page page = new Page((long)criteria.getPageIndex(), (long)criteria.getPageSize());
        IPage rollCallPlanEntityIPage = this.rollCallPlanMapper.selectPage((IPage)page, (Wrapper)lambdaQueryWrapper);
        return EntityCollection.create((Collection)rollCallPlanEntityIPage.getRecords(), (int)criteria.getPageSize(), (Long)rollCallPlanEntityIPage.getTotal());
    }

    public Collection<RollCallPlanEntity> getScheduledRollCallPlans(Timestamp scheduledTime, RepetitiveRule repetitiveRule) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.eq(RollCallPlanEntity::isDeleted, (Object)false);
        Calendar scheduledDate = Calendar.getInstance();
        scheduledDate.setTime(scheduledTime);
        scheduledDate.set(11, 0);
        scheduledDate.set(12, 0);
        scheduledDate.set(13, 0);
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.le(RollCallPlanEntity::getBeginDate, (Object)scheduledDate.getTime());
        Calendar endDateCalendar = Calendar.getInstance();
        endDateCalendar.setTime(scheduledDate.getTime());
        endDateCalendar.add(5, 1);
        Date endScheduledDate = endDateCalendar.getTime();
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.gt(RollCallPlanEntity::getEndDate, (Object)endScheduledDate);
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.apply("repetitive_rule & " + repetitiveRule.getValue() + " > 0", new Object[0]);
        List result = this.rollCallPlanMapper.selectList((Wrapper)lambdaQueryWrapper);
        return result;
    }
}

