/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bcxin.tenant.open.domains.dtos.UpdateEmployeeLocationDTO;
import com.bcxin.tenant.open.domains.entities.RdEmployeeEntity;
import com.bcxin.tenant.open.domains.mappers.RdEmployeeMapper;
import com.bcxin.tenant.open.domains.mappers.RdTenantUserAccountViewMapper;
import com.bcxin.tenant.open.domains.repositories.RdEmployeeRepository;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RdEmployeeRepositoryImpl
implements RdEmployeeRepository {
    private final RdEmployeeMapper employeeMapper;
    private final SqlSessionFactory sqlSessionFactory;
    private final RdTenantUserAccountViewMapper tenantUserViewMapper;

    public RdEmployeeRepositoryImpl(RdEmployeeMapper employeeMapper, SqlSessionFactory sqlSessionFactory, RdTenantUserAccountViewMapper tenantUserViewMapper) {
        this.employeeMapper = employeeMapper;
        this.sqlSessionFactory = sqlSessionFactory;
        this.tenantUserViewMapper = tenantUserViewMapper;
    }

    public RdEmployeeEntity getById(Object id) {
        return (RdEmployeeEntity)this.employeeMapper.selectById((Long)id);
    }

    public void insert(RdEmployeeEntity data) {
        this.employeeMapper.insert(data);
    }

    public void update(RdEmployeeEntity data) {
        this.employeeMapper.updateById(data);
    }

    public Collection<RdEmployeeEntity> getByPage(Collection<String> ids, int pageIndex, int pageSize) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (pageIndex <= 0) {
            pageIndex = 1;
        }
        if (!CollectionUtils.isEmpty(ids)) {
            wrapper = (LambdaQueryWrapper)wrapper.in(RdEmployeeEntity::getId, ids);
        }
        Page page = new Page((long)pageIndex, (long)pageSize);
        IPage employeeEntityPage = this.employeeMapper.selectPage((IPage)page, (Wrapper)wrapper);
        return employeeEntityPage.getRecords();
    }

    public void batchUpdate(Collection<RdEmployeeEntity> employees) {
        if (CollectionUtils.isEmpty(employees)) {
            return;
        }
        try (SqlSession session = this.sqlSessionFactory.openSession(ExecutorType.BATCH);){
            try {
                RdEmployeeMapper mapper = (RdEmployeeMapper)session.getMapper(RdEmployeeMapper.class);
                for (RdEmployeeEntity employee : employees) {
                    mapper.updateById(employee);
                }
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
    }

    public void resetExpiredStationIdByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.employeeMapper.resetExpiredStationIdByIds(ids);
    }

    public RdEmployeeEntity getByNoPkId(String id) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(RdEmployeeEntity::getId, (Object)id);
        return (RdEmployeeEntity)this.employeeMapper.selectOne((Wrapper)lambdaQueryWrapper);
    }

    public Collection<RdEmployeeEntity> getAllByNoPkIds(Collection<String> ids) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(RdEmployeeEntity::getId, ids);
        return this.employeeMapper.selectList((Wrapper)lambdaQueryWrapper);
    }

    public Collection<String> getCheckingEmployeeIds(int pageIndex, int pageSize) {
        if (pageIndex < 1) {
            pageIndex = 1;
        }
        return this.tenantUserViewMapper.getCheckingEmployeeIds((pageIndex - 1) * pageSize, pageSize);
    }

    public RdEmployeeEntity getByTenantEmployeeId(String employeeId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.eq(RdEmployeeEntity::getTenantEmployeeId, (Object)employeeId);
        return (RdEmployeeEntity)this.employeeMapper.selectOne((Wrapper)lambdaQueryWrapper);
    }

    public Collection<String> getNonUsedRecords(int pageSize) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.eq(RdEmployeeEntity::getSecurityStationId, (Object)"#1");
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.last(String.format("LIMIT %s", pageSize));
        lambdaQueryWrapper = lambdaQueryWrapper.select(new SFunction[]{RdEmployeeEntity::getId});
        List maps = this.employeeMapper.selectMaps((Wrapper)lambdaQueryWrapper);
        return maps.stream().map(ii -> String.valueOf(ii.get("id"))).collect(Collectors.toList());
    }

    public int deleteNonUsedRecords(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return 0;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(RdEmployeeEntity::getId, ids);
        return this.employeeMapper.delete((Wrapper)lambdaQueryWrapper);
    }

    public void batchUpdateLocations(Collection<UpdateEmployeeLocationDTO> data) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.employeeMapper.batchUpdateLocations(data);
    }
}

