/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bcxin.tenant.open.domains.criterias.ProjectAdvanceSearchCriteria;
import com.bcxin.tenant.open.domains.entities.RdProjectEntity;
import com.bcxin.tenant.open.domains.mappers.RdProjectMapper;
import com.bcxin.tenant.open.domains.repositories.RdProjectRepository;
import com.bcxin.tenant.open.infrastructures.EntityCollection;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Repository
public class RdProjectRepositoryImpl
implements RdProjectRepository {
    private final RdProjectMapper projectMapper;

    public RdProjectRepositoryImpl(RdProjectMapper projectMapper) {
        this.projectMapper = projectMapper;
    }

    public RdProjectEntity getById(Object id) {
        return (RdProjectEntity)this.projectMapper.selectById((Long)id);
    }

    public void insert(RdProjectEntity data) {
        this.projectMapper.insert(data);
    }

    public void update(RdProjectEntity data) {
        this.projectMapper.updateById(data);
    }

    public Collection<RdProjectEntity> getByPage(Collection<String> ids, int pageIndex, int pageSize) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (pageIndex <= 0) {
            pageIndex = 1;
        }
        if (!CollectionUtils.isEmpty(ids)) {
            wrapper = (LambdaQueryWrapper)wrapper.in(RdProjectEntity::getId, ids);
        }
        Page page = new Page((long)pageIndex, (long)pageSize);
        IPage projectEntityPage = this.projectMapper.selectPage((IPage)page, (Wrapper)wrapper);
        return projectEntityPage.getRecords();
    }

    public EntityCollection<RdProjectEntity> search(ProjectAdvanceSearchCriteria criteria) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        int pageIndex = criteria.getPageIndex();
        if (pageIndex <= 0) {
            pageIndex = 1;
        }
        if (StringUtils.hasLength((String)criteria.getName())) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.like(RdProjectEntity::getName, (Object)criteria.getName().concat("%"));
        }
        if (StringUtils.hasLength((String)criteria.getType())) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.eq(RdProjectEntity::getType, (Object)criteria.getType());
        }
        Date beginDate = criteria.getBeginDate();
        Date endDate = criteria.getEndDate();
        if (criteria.getStatus() != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            switch (criteria.getStatus()) {
                case Normal: {
                    if (beginDate == null) {
                        beginDate = calendar.getTime();
                    } else if (calendar.getTime().after(beginDate)) {
                        beginDate = calendar.getTime();
                    }
                    if (endDate == null) {
                        endDate = calendar.getTime();
                        break;
                    }
                    if (!calendar.getTime().before(endDate)) break;
                    endDate = calendar.getTime();
                    break;
                }
                case NotBegin: {
                    if (beginDate == null) {
                        beginDate = calendar.getTime();
                        break;
                    }
                    if (!calendar.getTime().after(beginDate)) break;
                    beginDate = calendar.getTime();
                    break;
                }
                case EndYet: {
                    if (endDate == null) {
                        endDate = calendar.getTime();
                        break;
                    }
                    if (!calendar.getTime().before(endDate)) break;
                    endDate = calendar.getTime();
                }
            }
        }
        if (beginDate != null) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.ge(RdProjectEntity::getBeginDate, (Object)beginDate);
        }
        if (endDate != null) {
            Calendar endNewCalendar = Calendar.getInstance();
            endNewCalendar.setTime(endDate);
            endNewCalendar.add(1, 5);
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.le(RdProjectEntity::getType, (Object)endNewCalendar.getTime());
        }
        Page page = new Page((long)pageIndex, (long)criteria.getPageSize());
        IPage projectEntityPage = this.projectMapper.selectPage((IPage)page, (Wrapper)lambdaQueryWrapper);
        return EntityCollection.create((Collection)projectEntityPage.getRecords(), (int)criteria.getPageSize(), (Long)projectEntityPage.getTotal());
    }

    public RdProjectEntity getByV5Id(String id) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.eq(RdProjectEntity::getId, (Object)id);
        return (RdProjectEntity)this.projectMapper.selectOne((Wrapper)lambdaQueryWrapper);
    }
}

