/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bcxin.tenant.open.domains.criterias.AttendanceAdvanceCriteria;
import com.bcxin.tenant.open.domains.criterias.AttendanceAdvanceDetailCriteria;
import com.bcxin.tenant.open.domains.criterias.AttendanceCriteria;
import com.bcxin.tenant.open.domains.criterias.MyAttendanceCriteria;
import com.bcxin.tenant.open.domains.criterias.MyRecentlyAttendanceCriteria;
import com.bcxin.tenant.open.domains.dtos.AttendanceCompanyGroupDTO;
import com.bcxin.tenant.open.domains.dtos.AttendanceCompanyGroupDetailDTO;
import com.bcxin.tenant.open.domains.dtos.AttendanceRepDTO;
import com.bcxin.tenant.open.domains.dtos.MyAttendanceRecordDTO;
import com.bcxin.tenant.open.domains.entities.TenantEmployeeAttendanceEntity;
import com.bcxin.tenant.open.domains.mappers.AttendanceMapper;
import com.bcxin.tenant.open.domains.repositories.AttendanceRepository;
import com.bcxin.tenant.open.domains.utils.DateUtils;
import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.infrastructures.TenantContext;
import com.bcxin.tenant.open.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.open.infrastructures.enums.AttendanceSearchModel;
import com.bcxin.tenant.open.infrastructures.enums.RecordStatus;
import com.bcxin.tenant.open.infrastructures.exceptions.NotSupportTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.UnAuthorizedTenantException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Repository
public class AttendanceRepositoryImpl
implements AttendanceRepository {
    private final AttendanceMapper attendanceMapper;

    public AttendanceRepositoryImpl(AttendanceMapper attendanceMapper) {
        this.attendanceMapper = attendanceMapper;
    }

    public List<TenantEmployeeAttendanceEntity> getByDay(String tenantEmployeeId, String createdDate) {
        return this.attendanceMapper.getByDay(tenantEmployeeId, createdDate);
    }

    public TenantEmployeeAttendanceEntity getById(Object id) {
        return null;
    }

    public void insert(TenantEmployeeAttendanceEntity data) {
        this.attendanceMapper.insert(data);
    }

    public void batchInsert(Collection<TenantEmployeeAttendanceEntity> data) {
        if (!CollectionUtils.isEmpty(data)) {
            this.attendanceMapper.batchInsert(data);
        }
    }

    public void batchInsertForStation(Collection<TenantEmployeeAttendanceEntity> data) {
        if (!CollectionUtils.isEmpty(data)) {
            this.attendanceMapper.batchInsertForStation(data);
        }
    }

    public void update(TenantEmployeeAttendanceEntity data) {
    }

    public IPage<AttendanceRepDTO> find(AttendanceCriteria criteria) {
        int pageIndex = criteria.getPageIndex();
        int pageSize = criteria.getPageSize();
        if (pageIndex <= 0) {
            pageIndex = 1;
        }
        Page page = new Page((long)pageIndex, (long)pageSize);
        List<AttendanceRepDTO> attendancePage = this.attendanceMapper.find((IPage<AttendanceRepDTO>)page, criteria);
        page.setRecords(attendancePage);
        return page;
    }

    public TenantEmployeeAttendanceEntity getMaxItemByEmployeeId(String employeeId) {
        return this.attendanceMapper.getMaxItemByEmployeeId(employeeId);
    }

    public Collection<TenantEmployeeAttendanceEntity> getEmployeeAttendances(String employeeId, Date beginDate, Date endDate) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper = (LambdaQueryWrapper)queryWrapper.eq(TenantEmployeeAttendanceEntity::getTenantEmployeeId, (Object)employeeId);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (beginDate != null) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.ge(TenantEmployeeAttendanceEntity::getCreatedTime, (Object)dateFormat.format(beginDate));
        }
        if (endDate != null) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.lt(TenantEmployeeAttendanceEntity::getCreatedTime, (Object)dateFormat.format(endDate));
        }
        return this.attendanceMapper.selectList((Wrapper)queryWrapper);
    }

    public EntityCollection<TenantEmployeeAttendanceEntity> search(AttendanceCriteria criteria) {
        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel == null) {
            throw new UnAuthorizedTenantException();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        switch (criteria.getSearchModel()) {
            case AdvanceSearch: {
                if (StringUtils.hasLength((String)criteria.getName())) {
                    lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.likeRight(TenantEmployeeAttendanceEntity::getName, (Object)criteria.getName());
                }
                if (StringUtils.hasLength((String)criteria.getCompanyName())) {
                    lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.likeRight(TenantEmployeeAttendanceEntity::getCompanyName, (Object)criteria.getCompanyName());
                }
                if (StringUtils.hasLength((String)criteria.getSecurityStationName())) {
                    lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.likeRight(TenantEmployeeAttendanceEntity::getSecurityStationName, (Object)criteria.getSecurityStationName());
                }
                if (criteria.getCreatedStarDate() != null) {
                    lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.ge(TenantEmployeeAttendanceEntity::getCreatedTime, (Object)criteria.getCreatedStarDate());
                }
                if (criteria.getCreatedEndDate() != null) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(criteria.getCreatedEndDate());
                    calendar.add(1, 5);
                    Date endDate = calendar.getTime();
                    lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.lt(TenantEmployeeAttendanceEntity::getCreatedTime, (Object)endDate);
                }
                if (!StringUtils.hasLength((String)criteria.getIdCardNo())) break;
                lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.likeRight(TenantEmployeeAttendanceEntity::getIdCardNo, (Object)criteria.getIdCardNo());
                break;
            }
            case Today: {
                return this.searchByToday(userModel, criteria);
            }
            case RecentWeek: {
                lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.eq(TenantEmployeeAttendanceEntity::getTenantEmployeeId, (Object)userModel.getEmployeeId());
                lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.ge(TenantEmployeeAttendanceEntity::getCreatedTime, (Object)DateUtils.getWeekDate());
                lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.lt(TenantEmployeeAttendanceEntity::getCreatedTime, (Object)DateUtils.getTomorrowDate());
                break;
            }
            case RecentMonth: {
                lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.eq(TenantEmployeeAttendanceEntity::getTenantEmployeeId, (Object)userModel.getEmployeeId());
                lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.ge(TenantEmployeeAttendanceEntity::getCreatedTime, (Object)DateUtils.getMonthDate());
                lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.lt(TenantEmployeeAttendanceEntity::getCreatedTime, (Object)DateUtils.getTomorrowDate());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getSuperviseDepartIds())) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.in(TenantEmployeeAttendanceEntity::getSuperviseDepartId, criteria.getSuperviseDepartIds());
        }
        if (!criteria.isHasManagedProjectIds()) {
            if (!CollectionUtils.isEmpty((Collection)criteria.getOrganizationIds()) && !CollectionUtils.isEmpty((Collection)criteria.getOtherSpecialPermissionScopeIds())) {
                lambdaQueryWrapper.and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.in(TenantEmployeeAttendanceEntity::getOrganizationId, criteria.getOrganizationIds())).or()).in(TenantEmployeeAttendanceEntity::getReferenceNumber, criteria.getOtherSpecialPermissionScopeIds()));
            } else if (!CollectionUtils.isEmpty((Collection)criteria.getOrganizationIds())) {
                lambdaQueryWrapper.in(TenantEmployeeAttendanceEntity::getOrganizationId, criteria.getOrganizationIds());
            } else if (!CollectionUtils.isEmpty((Collection)criteria.getOtherSpecialPermissionScopeIds())) {
                lambdaQueryWrapper.in(TenantEmployeeAttendanceEntity::getReferenceNumber, criteria.getOtherSpecialPermissionScopeIds());
            }
        } else {
            if (!CollectionUtils.isEmpty((Collection)criteria.getOrganizationIds()) && !CollectionUtils.isEmpty((Collection)criteria.getManagedProjectIds())) {
                lambdaQueryWrapper.and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.in(TenantEmployeeAttendanceEntity::getOrganizationId, criteria.getOrganizationIds())).or()).in(TenantEmployeeAttendanceEntity::getProjectId, criteria.getManagedProjectIds()));
            } else if (!CollectionUtils.isEmpty((Collection)criteria.getOrganizationIds())) {
                lambdaQueryWrapper.in(TenantEmployeeAttendanceEntity::getOrganizationId, criteria.getOrganizationIds());
            } else if (!CollectionUtils.isEmpty((Collection)criteria.getManagedProjectIds())) {
                lambdaQueryWrapper.in(TenantEmployeeAttendanceEntity::getProjectId, criteria.getManagedProjectIds());
            }
            if (!CollectionUtils.isEmpty((Collection)criteria.getOtherSpecialPermissionScopeIds())) {
                lambdaQueryWrapper.in(TenantEmployeeAttendanceEntity::getReferenceNumber, criteria.getOtherSpecialPermissionScopeIds());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getProjectIds())) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.in(TenantEmployeeAttendanceEntity::getProjectId, criteria.getProjectIds());
        }
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.orderByDesc(TenantEmployeeAttendanceEntity::getId);
        if (!criteria.ignorePage()) {
            Page page = new Page((long)criteria.getPageIndex(), (long)criteria.getPageSize());
            IPage attendanceEntityIPage = this.attendanceMapper.selectPage((IPage)page, (Wrapper)lambdaQueryWrapper);
            return EntityCollection.create((Collection)attendanceEntityIPage.getRecords(), (int)criteria.getPageSize(), (Long)attendanceEntityIPage.getTotal());
        }
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.last(String.format("limit %s, %s ", criteria.getSkip(), criteria.getPageSize()));
        List attendanceEntities = this.attendanceMapper.selectList((Wrapper)lambdaQueryWrapper);
        return EntityCollection.createForNoTotalCount((Collection)attendanceEntities, (int)criteria.getPageSize());
    }

    public EntityCollection<AttendanceCompanyGroupDTO> searchByAdvanceGroup(AttendanceAdvanceCriteria criteria) {
        Collection<AttendanceCompanyGroupDTO> result = this.attendanceMapper.searchByAdvanceGroup(criteria);
        if (!criteria.ignorePage()) {
            long totalCount = this.attendanceMapper.getTotalCountByAdvanceGroup(criteria);
            return EntityCollection.create(result, (int)criteria.getPageSize(), (Long)totalCount);
        }
        return EntityCollection.createForNoTotalCount(result, (int)criteria.getPageSize());
    }

    public EntityCollection<AttendanceCompanyGroupDetailDTO> searchByAdvanceGroupDetail(AttendanceAdvanceDetailCriteria criteria) {
        Collection<AttendanceCompanyGroupDetailDTO> result = this.attendanceMapper.searchByAdvanceGroupDetail(criteria);
        if (!criteria.ignorePage()) {
            long totalCount = this.attendanceMapper.getTotalCountByAdvanceGroupDetail(criteria);
            return EntityCollection.create(result, (int)criteria.getPageSize(), (Long)totalCount);
        }
        return EntityCollection.createForNoTotalCount(result, (int)criteria.getPageSize());
    }

    public int cleanRecentlyRecords() {
        Date now = new Date();
        Date expiredTime = DateUtils.addDay(now, -3);
        return this.attendanceMapper.cleanRecentlyRecords(expiredTime);
    }

    public Collection<MyAttendanceRecordDTO> search(MyAttendanceCriteria criteria) {
        if (criteria.getSearchModel() == AttendanceSearchModel.Today) {
            return this.searchMyRecentlyRecords(criteria);
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ArrayList<Integer> recordStatuses = new ArrayList<Integer>();
        recordStatuses.add(RecordStatus.SignIn.ordinal());
        recordStatuses.add(RecordStatus.SignOut.ordinal());
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.in(TenantEmployeeAttendanceEntity::getRecordStatus, recordStatuses);
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.eq(TenantEmployeeAttendanceEntity::getTenantEmployeeId, (Object)criteria.getEmployeeId());
        switch (criteria.getSearchModel()) {
            case RecentWeek: {
                lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.ge(TenantEmployeeAttendanceEntity::getCreatedTime, (Object)DateUtils.getWeekDate());
                lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.lt(TenantEmployeeAttendanceEntity::getCreatedTime, (Object)DateUtils.getTomorrowDate());
                break;
            }
            case RecentMonth: {
                lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.ge(TenantEmployeeAttendanceEntity::getCreatedTime, (Object)DateUtils.getMonthDate());
                lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.lt(TenantEmployeeAttendanceEntity::getCreatedTime, (Object)DateUtils.getTomorrowDate());
                break;
            }
            default: {
                throw new NotSupportTenantException();
            }
        }
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.last(String.format("limit %s, %s ", criteria.getSkip(), criteria.getPageSize()));
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.orderByDesc(TenantEmployeeAttendanceEntity::getId);
        List attendanceEntities = this.attendanceMapper.selectList((Wrapper)lambdaQueryWrapper);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return attendanceEntities.stream().map(ix -> MyAttendanceRecordDTO.create((String)dateFormat.format(ix.getCreatedTime()), (RecordStatus)ix.getRecordStatus(), (String)ix.getName(), (String)ix.getAddress())).collect(Collectors.toList());
    }

    private Collection<MyAttendanceRecordDTO> searchMyRecentlyRecords(MyAttendanceCriteria criteria) {
        MyRecentlyAttendanceCriteria recentlyAttendanceCriteria = MyRecentlyAttendanceCriteria.create((int)criteria.getPageIndex(), (int)criteria.getPageSize(), (String)criteria.getEmployeeId(), (int)DateUtils.getTodayDateValue());
        Collection<MyAttendanceRecordDTO> records = this.attendanceMapper.searchMyRecentlyRecords(recentlyAttendanceCriteria);
        return records;
    }

    private EntityCollection<TenantEmployeeAttendanceEntity> searchByToday(TenantEmployeeContext.TenantUserModel userModel, AttendanceCriteria criteria) {
        MyRecentlyAttendanceCriteria recentlyAttendanceCriteria = MyRecentlyAttendanceCriteria.create((int)criteria.getPageIndex(), (int)criteria.getPageSize(), (String)userModel.getEmployeeId(), (int)DateUtils.getTodayDateValue());
        Collection<TenantEmployeeAttendanceEntity> entities = this.attendanceMapper.searchByRecently(recentlyAttendanceCriteria);
        long count = this.attendanceMapper.getTotalCountByRecently(recentlyAttendanceCriteria);
        return EntityCollection.create(entities, (int)criteria.getPageSize(), (Long)count);
    }
}

