/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.bcxin.tenant.open.domains.dtos.SyncDataWrapperDTO;
import com.bcxin.tenant.open.domains.dtos.SyncDbCheckQueryDTO;
import com.bcxin.tenant.open.domains.mappers.RdSyncDataMapper;
import com.bcxin.tenant.open.domains.mappers.RdSyncEventProjectDataMapper;
import com.bcxin.tenant.open.domains.mappers.dtos.SyncDataRequestWrapperDTO;
import com.bcxin.tenant.open.domains.repositories.RdSyncDataRepository;
import com.bcxin.tenant.open.infrastructures.constants.BusinessConstants;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.NotSupportTenantException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Repository
public class RdSyncDataRepositoryImpl
implements RdSyncDataRepository {
    private final RdSyncDataMapper syncDataMapper;
    private final RdSyncEventProjectDataMapper syncEventProjectDataMapper;

    public RdSyncDataRepositoryImpl(RdSyncDataMapper syncDataMapper, RdSyncEventProjectDataMapper syncEventProjectDataMapper) {
        this.syncDataMapper = syncDataMapper;
        this.syncEventProjectDataMapper = syncEventProjectDataMapper;
    }

    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    public void reloadSyncData(SyncDataWrapperDTO dataWrapper) {
        SyncDataRequestWrapperDTO data = SyncDataRequestWrapperDTO.create(dataWrapper.getIds(), dataWrapper.getAdditionalParameter());
        switch (dataWrapper.getDataType()) {
            case User: {
                if (CollectionUtils.isEmpty((Collection)dataWrapper.getIds())) break;
                this.syncDataMapper.reloadSyncUsers(data);
                break;
            }
            case Employee: {
                this.syncDataMapper.reloadSyncEmployees(data);
                break;
            }
            case Station: {
                this.syncDataMapper.reloadSyncStations(data);
                this.syncEventProjectDataMapper.reloadSyncPostManagersByResourceId(data);
                break;
            }
            case Company: {
                this.syncDataMapper.reloadSyncCompanies(data);
                break;
            }
            case ExamRoom: {
                this.syncDataMapper.reloadSyncExamSiteRooms(data);
                break;
            }
            case ExamSite: {
                this.syncDataMapper.reloadSyncExamSites(data);
                break;
            }
            case SystemExamInfo: {
                this.syncDataMapper.reloadSyncExamInfo(data);
                break;
            }
            case RefreshCompanyDesks: {
                this.syncDataMapper.reloadSyncCompanyDesks(data);
                break;
            }
            case RefreshCompanyPoints: {
                this.syncDataMapper.reloadSyncCompanyPoints(data);
                break;
            }
            case CommunityUser: {
                this.syncDataMapper.reloadCommunityUsers(data);
                break;
            }
            case SuperviseDeparts: {
                this.syncDataMapper.reloadSuperviseDeparts(data);
                break;
            }
            case ProprietorStations: {
                this.syncDataMapper.reloadProprietorStations(data);
                break;
            }
            case CompanyPermissions: {
                this.syncDataMapper.reloadCompanyPermissions(data);
                break;
            }
            case TemporaryProtectionProject: {
                Collection ids = dataWrapper.getIds();
                if (CollectionUtils.isEmpty((Collection)ids)) {
                    return;
                }
                Collection tempProjIds = ids.stream().filter(ii -> BusinessConstants.isTemporaryProjectIdStuffId((String)ii)).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty((Collection)tempProjIds)) {
                    this.syncDataMapper.reloadTemporaryProtectionProject(SyncDataRequestWrapperDTO.create(tempProjIds, tempProjIds));
                }
                Collection<String> eventProjectIds = new ArrayList<String>();
                if (!CollectionUtils.isEmpty((Collection)ids)) {
                    eventProjectIds = ids.stream().filter(ii -> BusinessConstants.isEventProjectIdStuffId((String)ii)).collect(Collectors.toSet());
                }
                if (CollectionUtils.isEmpty(eventProjectIds)) break;
                SyncDataRequestWrapperDTO eventProjectData = SyncDataRequestWrapperDTO.create(eventProjectIds, eventProjectIds);
                this.syncEventProjectDataMapper.reloadSyncProjects(eventProjectData);
                this.syncEventProjectDataMapper.reloadSyncPostManagersByResourceId(data);
                this.syncEventProjectDataMapper.reloadSyncTeamsByProjectId(data);
                this.syncEventProjectDataMapper.reloadSyncPostManagersByProjectId(data);
                break;
            }
            case TemporaryProtectionProjectGroup: {
                this.syncDataMapper.reloadTemporaryProjectGroup(data);
                break;
            }
            case TemporaryProtectionProjectMember: {
                this.syncDataMapper.reloadTemporaryProjectMember(data);
                break;
            }
            case HareWareDevice: 
            case Device: {
                this.syncDataMapper.reloadHardwareDevices(data);
                break;
            }
            case TemporaryProtectionProjectPersonType: {
                this.syncDataMapper.reloadTemporaryProjectPersonTypes(data);
                break;
            }
            case EventOrganizerJoinProject: {
                this.syncDataMapper.reloadEventOrgPermissions(data);
                this.syncEventProjectDataMapper.reloadSyncTeams(data);
                break;
            }
            case EventOrganizerStationManager: {
                this.syncDataMapper.reloadEventOrgEmpPermissions(data);
                this.syncEventProjectDataMapper.reloadSyncPostManagers(data);
                break;
            }
            case EventOrganizerLimitedResource: {
                this.syncEventProjectDataMapper.reloadSyncTeamsLimitedResources(data);
                break;
            }
            case DispatchDataSource: {
                this.syncDataMapper.reloadDispatchDataSources(data);
                break;
            }
            case Member: {
                this.syncDataMapper.reloadMembers(data);
                break;
            }
            case VideoDevice: {
                this.syncDataMapper.reloadStationVideos(data);
                break;
            }
            default: {
                throw new NotSupportTenantException("\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b");
            }
        }
    }

    public void clearExpiredProprietorStations(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BadTenantException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.syncDataMapper.clearExpiredProprietorStations(ids);
    }

    public Collection<String> getRelativeIds(SyncDbCheckQueryDTO criteria) {
        return this.syncDataMapper.getRelativeIds(criteria);
    }
}

