/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bcxin.tenant.open.domains.dtos.DeviceBatchUpdateDTO;
import com.bcxin.tenant.open.domains.entities.RdDeviceEntity;
import com.bcxin.tenant.open.domains.mappers.RdDeviceMapper;
import com.bcxin.tenant.open.domains.repositories.RdDeviceRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class RdDeviceRepositoryImpl
implements RdDeviceRepository {
    private final RdDeviceMapper deviceMapper;

    public RdDeviceRepositoryImpl(RdDeviceMapper deviceMapper) {
        this.deviceMapper = deviceMapper;
    }

    public RdDeviceEntity getById(Object id) {
        return (RdDeviceEntity)this.deviceMapper.selectById((Long)id);
    }

    public void insert(RdDeviceEntity data) {
        this.deviceMapper.insert(data);
    }

    public void update(RdDeviceEntity data) {
        this.deviceMapper.updateById(data);
    }

    public Collection<RdDeviceEntity> getByPage(Collection<String> ids, int pageIndex, int pageSize) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (pageIndex <= 0) {
            pageIndex = 1;
        }
        if (!CollectionUtils.isEmpty(ids)) {
            wrapper = (LambdaQueryWrapper)wrapper.in(RdDeviceEntity::getId, ids);
        }
        Page page = new Page((long)pageIndex, (long)pageSize);
        IPage deviceEntityIPage = this.deviceMapper.selectPage((IPage)page, (Wrapper)wrapper);
        return deviceEntityIPage.getRecords();
    }

    public Collection<RdDeviceEntity> getNoReadyDevices(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.EMPTY_LIST;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper = (LambdaQueryWrapper)wrapper.in(RdDeviceEntity::getId, ids);
        return this.deviceMapper.selectList((Wrapper)wrapper);
    }

    public Collection<String> batchUpdate(DeviceBatchUpdateDTO data) {
        if (data == null || CollectionUtils.isEmpty((Collection)data.getItems())) {
            return Collections.EMPTY_LIST;
        }
        Collection deviceNos = data.getItems().stream().map(ii -> ii.getDeviceNo()).collect(Collectors.toSet());
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.in(RdDeviceEntity::getDeviceNo, deviceNos);
        List devices = this.deviceMapper.selectList((Wrapper)lambdaQueryWrapper);
        for (RdDeviceEntity device : devices) {
            Optional<String> deviceUidOptional = data.getItems().stream().filter(ii -> ii.getDeviceNo().equals(device.getDeviceNo())).map(ii -> ii.getDeviceUid()).findFirst();
            if (deviceUidOptional.isPresent()) {
                device.setDeviceUid(deviceUidOptional.get());
            }
            this.deviceMapper.updateById(device);
        }
        return devices.stream().map(ii -> ii.getId()).collect(Collectors.toSet());
    }
}

