/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.utils;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DateUtils {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final String MONTH_TIME_PATTERN = "yyyy-MM";
    public static final String YEAR_TIME_PATTERN = "yyyy";
    public static final long MILLISECONDS_PER_DAY = 86400000L;
    public static final long DAYS_PER_WEEK = 7L;
    public static final long MILLISECONDS_PER_HOUR = 3600000L;
    public static final long SECONDS_PER_MINUTE = 60L;
    public static final long SECONDS_PER_HOUR = 3600L;
    public static final long SECONDS_PER_DAY = 86400L;
    public static final long SECONDS_PER_MONTH = 2592000L;
    public static final long SECONDS_PER_YEAR = 31536000L;
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm"};

    public static String getDate() {
        return DateUtils.getDate(DATE_FORMAT);
    }

    public static String getTime() {
        return DateUtils.formatDate(new Date(), TIME_FORMAT);
    }

    public static String getDateTime() {
        return DateUtils.formatDate(new Date(), DATETIME_FORMAT);
    }

    public static String getDate(String pattern) {
        return DateFormatUtils.format((Date)new Date(), (String)pattern);
    }

    public static String getDate(Date date, String pattern) {
        return DateFormatUtils.format((Date)date, (String)pattern);
    }

    public static String formatDate(Date date, Object ... pattern) {
        String formatDate = null;
        formatDate = pattern != null && pattern.length > 0 ? DateFormatUtils.format((Date)date, (String)pattern[0].toString()) : DateFormatUtils.format((Date)date, (String)DATE_FORMAT);
        return formatDate;
    }

    public static String getYear() {
        return DateUtils.formatDate(new Date(), YEAR_TIME_PATTERN);
    }

    public static String getMonth() {
        return DateUtils.formatDate(new Date(), "MM");
    }

    public static String getDay() {
        return DateUtils.formatDate(new Date(), "dd");
    }

    public static String getWeek() {
        return DateUtils.formatDate(new Date(), "E");
    }

    public static Date parseDate(Object str) {
        if (str == null) {
            return null;
        }
        try {
            return org.apache.commons.lang3.time.DateUtils.parseDate((String)str.toString(), (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parse(String strDate, String pattern) {
        Date d = null;
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            d = df.parse(strDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return d;
    }

    public static long pastDays(Date date) {
        date = DateUtils.parseDate(DateUtils.formatDate(date, DATE_FORMAT));
        Date currentDate = DateUtils.parseDate(DateUtils.formatDate(new Date(), DATE_FORMAT));
        long t = 0L;
        if (date != null && currentDate != null) {
            t = (currentDate.getTime() - date.getTime()) / 86400000L;
        }
        return t;
    }

    public static Date nextDay(int num) {
        Calendar curr = Calendar.getInstance();
        curr.set(5, curr.get(5) + num);
        return curr.getTime();
    }

    public static Date nextMonth(int num) {
        Calendar curr = Calendar.getInstance();
        curr.set(2, curr.get(2) + num);
        return curr.getTime();
    }

    public static Date nextYear(int num) {
        Calendar curr = Calendar.getInstance();
        curr.set(1, curr.get(1) + num);
        return curr.getTime();
    }

    public static Calendar getCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        return calendar;
    }

    public static long getDaysBetween(Date start, Date end) {
        start = DateUtils.parseDate(DateUtils.formatDate(start, DATE_FORMAT));
        end = DateUtils.parseDate(DateUtils.formatDate(end, DATE_FORMAT));
        long diff = 0L;
        if (start != null && end != null) {
            diff = (end.getTime() - start.getTime()) / 86400000L;
        }
        return diff;
    }

    public static long getWeeksBetween(Date start, Date end) {
        return DateUtils.getDaysBetween(start, end) / 7L;
    }

    public static String getSpecifiedDayAfter(String specifiedDay, int num) {
        Date specifiedDate = DateUtils.parseDate(specifiedDay);
        Calendar c = Calendar.getInstance();
        c.setTime(specifiedDate);
        int day = c.get(5);
        c.set(5, day + num);
        String dayAfter = DateUtils.formatDate(c.getTime(), DATE_FORMAT);
        return dayAfter;
    }

    public static String dateMinus(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return "0";
        }
        Long r = date1.getTime() - date2.getTime();
        DecimalFormat df = new DecimalFormat("#.0");
        double result = (double)r.longValue() * 1.0 / 3600000.0;
        return df.format(result);
    }

    public static Integer getCurrentSeason() {
        Calendar calendar = Calendar.getInstance();
        Integer month = calendar.get(2) + 1;
        int season = 0;
        if (month >= 1 && month <= 3) {
            season = 1;
        } else if (month >= 4 && month <= 6) {
            season = 2;
        } else if (month >= 7 && month <= 9) {
            season = 3;
        } else if (month >= 10 && month <= 12) {
            season = 4;
        }
        return season;
    }

    public static String getIntervalBySeconds(long seconds) {
        StringBuffer buffer = new StringBuffer();
        if (seconds < 60L) {
            buffer.append(seconds).append("\u79d2\u524d");
        } else if (seconds < 3600L) {
            buffer.append(seconds / 60L).append("\u5206\u949f\u524d");
        } else if (seconds < 86400L) {
            buffer.append(seconds / 3600L).append("\u5c0f\u65f6\u524d");
        } else if (seconds < 2592000L) {
            buffer.append(seconds / 86400L).append("\u5929\u524d");
        } else if (seconds < 31536000L) {
            buffer.append(seconds / 2592000L).append("\u6708\u524d");
        } else {
            buffer.append(seconds / 31536000L).append("\u5e74\u524d");
        }
        return buffer.toString();
    }

    public static String getNowTimeBefore(long seconds) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\u4e0a\u4f20\u4e8e");
        if (seconds < 3600L) {
            buffer.append((long)Math.floor((double)seconds / 60.0)).append("\u5206\u949f\u524d");
        } else if (seconds < 86400L) {
            buffer.append((long)Math.floor((double)seconds / 3600.0)).append("\u5c0f\u65f6\u524d");
        } else if (seconds < 604800L) {
            buffer.append((long)Math.floor((double)seconds / 86400.0)).append("\u5929\u524d");
        } else if (seconds < 2592000L) {
            buffer.append((long)Math.floor((double)seconds / 604800.0)).append("\u5468\u524d");
        } else if (seconds < 31104000L) {
            buffer.append((long)Math.floor((double)seconds / 2592000.0)).append("\u6708\u524d");
        } else {
            buffer.append((long)Math.floor((double)seconds / 3.1104E7)).append("\u5e74\u524d");
        }
        return buffer.toString();
    }

    public static String getDayOfWeek(String dateStr) {
        String[] weekOfDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Date date = DateUtils.parseDate(dateStr);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int num = calendar.get(7) - 1;
        return weekOfDays[num];
    }

    public static String snsFormat(long createTime) {
        long now = System.currentTimeMillis() / 1000L;
        long differ = now - createTime / 1000L;
        Object dateStr = "";
        if (differ <= 60L) {
            dateStr = "\u521a\u521a";
        } else if (differ <= 3600L) {
            dateStr = differ / 60L + "\u5206\u949f\u524d";
        } else if (differ <= 86400L) {
            dateStr = differ / 3600L + "\u5c0f\u65f6\u524d";
        } else if (differ <= 2592000L) {
            dateStr = differ / 86400L + "\u5929\u524d";
        } else {
            Date date = new Date(createTime);
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            dateStr = sdf.format(date);
        }
        return dateStr;
    }

    public static String getUTCTimeStr() {
        StringBuffer UTCTimeBuffer = new StringBuffer();
        Calendar cal = Calendar.getInstance();
        int zoneOffset = cal.get(15);
        int dstOffset = cal.get(16);
        cal.add(14, -(zoneOffset + dstOffset));
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        UTCTimeBuffer.append(year).append("-").append(month).append("-").append(day);
        UTCTimeBuffer.append(" ").append(hour).append(":").append(minute);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            sdf.parse(UTCTimeBuffer.toString());
            return UTCTimeBuffer.toString();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date addYear(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, n);
        return cal.getTime();
    }

    public static Date addMonth(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, n);
        return cal.getTime();
    }

    public static Date addDay(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, n);
        return cal.getTime();
    }

    public static Date addHour(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(11, n);
        return cal.getTime();
    }

    public static Date getTomorrowDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, 1);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        return cal.getTime();
    }

    public static Date getYesterdayDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, -1);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        return cal.getTime();
    }

    public static Date getTodayDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        return cal.getTime();
    }

    public static int getTodayDateValue() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        return Integer.parseInt(dateFormat.format(new Date()));
    }

    public static Date getWeekDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, -7);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        return cal.getTime();
    }

    public static Date getMonthDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, -30);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        return cal.getTime();
    }

    public static Date getMonthFirstDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(cal.get(1), cal.get(2), 1, 0, 0, 0);
        return cal.getTime();
    }

    public static Date getLastMonthFirstDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(2, -1);
        cal.set(cal.get(1), cal.get(2), 1, 0, 0, 0);
        return cal.getTime();
    }

    public static Date getNMonthFirstDate(int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(2, n);
        cal.set(cal.get(1), cal.get(2), 1, 0, 0, 0);
        return cal.getTime();
    }

    public static Date getNextMonthFirstDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(2, 1);
        cal.set(cal.get(1), cal.get(2), 1, 0, 0, 0);
        return cal.getTime();
    }

    public static Date getYearFirstDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(cal.get(1), 0, 1, 0, 0, 0);
        return cal.getTime();
    }

    public static Date addMinute(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, n);
        return cal.getTime();
    }

    public static Date getLastYearFirstDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(1, -1);
        cal.set(cal.get(1), 0, 1, 0, 0, 0);
        return cal.getTime();
    }

    public static Date getNextYearFirstDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(1, 1);
        cal.set(cal.get(1), 0, 1, 0, 0, 0);
        return cal.getTime();
    }

    public static Date formatDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, 1);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        return cal.getTime();
    }

    public static Date getChainRatioStartDate(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return null;
        }
        return new Date(startDate.getTime() * 2L - endDate.getTime());
    }

    public static String secToTime(int time) {
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (time <= 0) {
            return "00:00:00";
        }
        if (time >= 3600) {
            hour = time / 3600;
            time %= 3600;
        }
        if (time >= 60) {
            minute = time / 60;
            second = time % 60;
        } else {
            second = time % 60;
        }
        return DateUtils.timeFormat(hour) + ":" + DateUtils.timeFormat(minute) + ":" + DateUtils.timeFormat(second);
    }

    public static String timeFormat(int num) {
        String retStr = null;
        retStr = num >= 0 && num < 10 ? "0" + Integer.toString(num) : "" + num;
        return retStr;
    }

    public static List<String> cutDate(String dateType, Date start, Date end) {
        try {
            String dBegin = DateUtils.getDate(start, DATETIME_FORMAT);
            String dEnd = DateUtils.getDate(end, DATETIME_FORMAT);
            SimpleDateFormat sdf = new SimpleDateFormat(DATETIME_FORMAT);
            Date cutBegin = sdf.parse(dBegin);
            Date cutEnd = sdf.parse(dEnd);
            return DateUtils.findDates(dateType, cutBegin, cutEnd);
        }
        catch (Exception e) {
            e.getMessage();
            return null;
        }
    }

    public static List<String> findDates(String dateType, Date dBegin, Date dEnd) throws Exception {
        ArrayList<String> listDate = new ArrayList<String>();
        listDate.add(new SimpleDateFormat(DATETIME_FORMAT).format(dBegin.getTime()));
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(dBegin);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(dEnd);
        while (calEnd.after(calBegin)) {
            switch (dateType) {
                case "M": {
                    calBegin.add(2, 1);
                    break;
                }
                case "D": {
                    calBegin.add(6, 1);
                    break;
                }
                case "H": {
                    calBegin.add(10, 1);
                    break;
                }
                case "N": {
                    calBegin.add(12, 10);
                    break;
                }
                case "Y": {
                    calBegin.add(1, 1);
                }
            }
            if (!calEnd.after(calBegin)) continue;
            listDate.add(new SimpleDateFormat(DATETIME_FORMAT).format(calBegin.getTime()));
        }
        return listDate;
    }

    public static List<String> cutDates(String dateType, Date start, Date end, int n) {
        try {
            String dBegin = DateUtils.getDate(start, DATETIME_FORMAT);
            String dEnd = DateUtils.getDate(end, DATETIME_FORMAT);
            SimpleDateFormat sdf = new SimpleDateFormat(DATETIME_FORMAT);
            Date cutBegin = sdf.parse(dBegin);
            Date cutEnd = sdf.parse(dEnd);
            return DateUtils.findDate(dateType, cutBegin, cutEnd, n);
        }
        catch (Exception e) {
            e.getMessage();
            return null;
        }
    }

    public static List<String> findDate(String dateType, Date dBegin, Date dEnd, int n) throws Exception {
        ArrayList<String> listDate = new ArrayList<String>();
        listDate.add(new SimpleDateFormat(DATETIME_FORMAT).format(dBegin.getTime()));
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(dBegin);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(dEnd);
        while (calEnd.after(calBegin)) {
            switch (dateType) {
                case "MONTH": {
                    calBegin.add(2, 1);
                    break;
                }
                case "DAY": {
                    calBegin.add(6, 1);
                    break;
                }
                case "CUSTOM": {
                    calBegin.add(6, n);
                    break;
                }
                case "YEAR": {
                    calBegin.add(1, 1);
                }
            }
            if (!calEnd.after(calBegin)) continue;
            listDate.add(new SimpleDateFormat(DATETIME_FORMAT).format(calBegin.getTime()));
        }
        return listDate;
    }

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }
}

