/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.RollCallStatus;
import com.bcxin.tenant.open.infrastructures.exceptions.NoAllowedTenantException;
import com.bcxin.tenant.open.jdks.requests.RequestAbstract;

public class RollCallAutoCancelEmployeeRequest
extends RequestAbstract {
    private final RollCallStatus callStatus;

    public RollCallAutoCancelEmployeeRequest(RollCallStatus callStatuses) {
        this.callStatus = callStatuses;
    }

    public static RollCallAutoCancelEmployeeRequest create(RollCallStatus callStatuses) {
        if (callStatuses != RollCallStatus.RollCallInit && callStatuses != RollCallStatus.DispatchInit) {
            throw new NoAllowedTenantException(String.format("%s is not allowed to be cancelled", callStatuses));
        }
        return new RollCallAutoCancelEmployeeRequest(callStatuses);
    }

    public RollCallStatus getCallStatus() {
        return this.callStatus;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RollCallAutoCancelEmployeeRequest)) {
            return false;
        }
        RollCallAutoCancelEmployeeRequest other = (RollCallAutoCancelEmployeeRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RollCallStatus this$callStatus = this.getCallStatus();
        RollCallStatus other$callStatus = other.getCallStatus();
        return !(this$callStatus == null ? other$callStatus != null : !this$callStatus.equals(other$callStatus));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RollCallAutoCancelEmployeeRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RollCallStatus $callStatus = this.getCallStatus();
        result = result * 59 + ($callStatus == null ? 43 : $callStatus.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RollCallAutoCancelEmployeeRequest(callStatus=" + this.getCallStatus() + ")";
    }
}

