/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bcxin.tenant.open.domains.dtos.LogoSettingDTO;
import com.bcxin.tenant.open.domains.dtos.ReadInstructionSettingDTO;
import com.bcxin.tenant.open.domains.dtos.SosSettingDTO;
import com.bcxin.tenant.open.domains.entities.TenantAccountEntity;
import com.bcxin.tenant.open.domains.mappers.TenantAccountMapper;
import com.bcxin.tenant.open.domains.repositories.TenantAccountRepository;
import com.bcxin.tenant.open.infrastructures.enums.DispatchAccountType;
import org.springframework.stereotype.Repository;

@Repository
public class TenantAccountRepositoryImpl
implements TenantAccountRepository {
    private final TenantAccountMapper tenantAccountMapper;

    public TenantAccountRepositoryImpl(TenantAccountMapper tenantAccountMapper) {
        this.tenantAccountMapper = tenantAccountMapper;
    }

    public TenantAccountEntity getById(Object id) {
        return (TenantAccountEntity)this.tenantAccountMapper.selectById((Long)id);
    }

    public void insert(TenantAccountEntity data) {
        this.tenantAccountMapper.insert(data);
    }

    public void update(TenantAccountEntity data) {
        this.tenantAccountMapper.updateById(data);
    }

    public void SosSetting(SosSettingDTO data) {
        this.tenantAccountMapper.SosSetting(data);
    }

    public void LogoSetting(LogoSettingDTO data) {
        this.tenantAccountMapper.LogoSetting(data);
    }

    public void UpdateReadOperationInstructionStatus(ReadInstructionSettingDTO readInstructionSettingDTO) {
        this.tenantAccountMapper.UpdateReadOperationInstructionStatus(readInstructionSettingDTO);
    }

    public TenantAccountEntity getByAccount(DispatchAccountType accountType, String deviceNo) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper = (LambdaQueryWrapper)queryWrapper.eq(TenantAccountEntity::getDeviceNo, (Object)deviceNo);
        queryWrapper = (LambdaQueryWrapper)queryWrapper.eq(TenantAccountEntity::getDeviceType, (Object)accountType.ordinal());
        TenantAccountEntity account = (TenantAccountEntity)this.tenantAccountMapper.selectOne((Wrapper)queryWrapper);
        return account;
    }
}

