/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bcxin.tenant.open.domains.criterias.DispatchLogSearchCriteria;
import com.bcxin.tenant.open.domains.criterias.SponsorDispatchLogSearchCriteria;
import com.bcxin.tenant.open.domains.dtos.SponsorDispatchLogDTO;
import com.bcxin.tenant.open.domains.entities.DeviceCommunicatedLogEntity;
import com.bcxin.tenant.open.domains.mappers.DeviceCommunicatedLogMapper;
import com.bcxin.tenant.open.domains.repositories.DeviceCommunicatedLogRepository;
import com.bcxin.tenant.open.infrastructures.EntityCollection;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Repository
public class DeviceCommunicatedLogRepositoryImpl
implements DeviceCommunicatedLogRepository {
    private final DeviceCommunicatedLogMapper deviceCommunicatedLogMapper;

    public DeviceCommunicatedLogRepositoryImpl(DeviceCommunicatedLogMapper deviceCommunicatedLogMapper) {
        this.deviceCommunicatedLogMapper = deviceCommunicatedLogMapper;
    }

    public DeviceCommunicatedLogEntity getById(Object id) {
        return (DeviceCommunicatedLogEntity)this.deviceCommunicatedLogMapper.selectById((Long)id);
    }

    public void insert(DeviceCommunicatedLogEntity data) {
        this.deviceCommunicatedLogMapper.insert(data);
    }

    public void update(DeviceCommunicatedLogEntity data) {
        this.deviceCommunicatedLogMapper.updateById(data);
    }

    public EntityCollection<DeviceCommunicatedLogEntity> search(DispatchLogSearchCriteria criteria) {
        int pageIndex;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (StringUtils.hasLength((String)criteria.getCallerName())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.likeLeft(DeviceCommunicatedLogEntity::getCallerCompanyName, (Object)criteria.getCallerName().trim().concat("%"));
        }
        if (StringUtils.hasLength((String)criteria.getCalledCompanyName())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.likeLeft(DeviceCommunicatedLogEntity::getCalledCompanyName, (Object)criteria.getCalledCompanyName().trim().concat("%"));
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getCallerDeviceNos())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.in(DeviceCommunicatedLogEntity::getCallerDeviceNo, criteria.getCallerDeviceNos());
        }
        if (!CollectionUtils.isEmpty((Collection)criteria.getSuperviseDepartIds())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.in(DeviceCommunicatedLogEntity::getDomainId, criteria.getSuperviseDepartIds());
        }
        if (criteria.getDispatchedDateFrom() != null) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.ge(DeviceCommunicatedLogEntity::getBeginTime, (Object)criteria.getDispatchedDateFrom());
        }
        if (criteria.getDeskTypes() != null) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.in(DeviceCommunicatedLogEntity::getDeskType, (Collection)criteria.getDeskTypes().stream().map(ii -> ii.ordinal()).collect(Collectors.toSet()));
        }
        if (criteria.getDispatchedDateTo() != null) {
            queryWrapper.and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.le(DeviceCommunicatedLogEntity::getEndTime, (Object)criteria.getDispatchedDateTo())).or()).isNull(DeviceCommunicatedLogEntity::getEndTime));
        }
        if (StringUtils.hasLength((String)criteria.getProjectName())) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.likeLeft(DeviceCommunicatedLogEntity::getProjectName, (Object)criteria.getProjectName().trim().concat("%"));
        }
        if ((pageIndex = criteria.getPageIndex()) <= 0) {
            pageIndex = 1;
        }
        queryWrapper = (LambdaQueryWrapper)queryWrapper.orderByDesc(DeviceCommunicatedLogEntity::getCreatedTime);
        if (!criteria.ignorePage()) {
            Page page = new Page((long)pageIndex, (long)criteria.getPageSize());
            IPage deviceCommunicatedLogs = this.deviceCommunicatedLogMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
            return EntityCollection.create((Collection)deviceCommunicatedLogs.getRecords(), (int)criteria.getPageSize(), (Long)deviceCommunicatedLogs.getTotal());
        }
        queryWrapper = (LambdaQueryWrapper)queryWrapper.last(String.format("limit %s, %s ", criteria.getSkip(), criteria.getPageSize()));
        List deviceCommunicatedLogs = this.deviceCommunicatedLogMapper.selectList((Wrapper)queryWrapper);
        return EntityCollection.createForNoTotalCount((Collection)deviceCommunicatedLogs, (int)criteria.getPageSize());
    }

    public void batchInsert(Collection<DeviceCommunicatedLogEntity> logs) {
        for (DeviceCommunicatedLogEntity ix : logs) {
            this.deviceCommunicatedLogMapper.insert(ix);
        }
    }

    public DeviceCommunicatedLogEntity getByNoPkId(String id) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(DeviceCommunicatedLogEntity::getId, (Object)id);
        return (DeviceCommunicatedLogEntity)this.deviceCommunicatedLogMapper.selectOne((Wrapper)lambdaQueryWrapper);
    }

    public Collection<SponsorDispatchLogDTO> search(SponsorDispatchLogSearchCriteria criteria) {
        return this.deviceCommunicatedLogMapper.searchSponsorDispatch(criteria);
    }
}

