/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bcxin.tenant.open.domains.criterias.RdSecurityStationRailCriteria;
import com.bcxin.tenant.open.domains.entities.RdSecurityStationRailEntity;
import com.bcxin.tenant.open.domains.mappers.RdSecurityStationRailMapper;
import com.bcxin.tenant.open.domains.repositories.RdSecurityStationRailRepository;
import com.bcxin.tenant.open.infrastructures.TenantContext;
import com.bcxin.tenant.open.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.open.infrastructures.enums.RailBusinessType;
import com.bcxin.tenant.open.infrastructures.exceptions.UnAuthorizedTenantException;
import com.bcxin.tenant.open.infrastructures.utils.DateUtils;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Repository
public class RdSecurityStationRailRepositoryImpl
implements RdSecurityStationRailRepository {
    private final RdSecurityStationRailMapper securityStationRailMapper;

    public RdSecurityStationRailRepositoryImpl(RdSecurityStationRailMapper securityStationRailMapper) {
        this.securityStationRailMapper = securityStationRailMapper;
    }

    public RdSecurityStationRailEntity getById(Object id) {
        return (RdSecurityStationRailEntity)this.securityStationRailMapper.selectById((Long)id);
    }

    public void insert(RdSecurityStationRailEntity data) {
        this.securityStationRailMapper.insert(data);
    }

    public void update(RdSecurityStationRailEntity data) {
        this.securityStationRailMapper.updateById(data);
    }

    public Collection<RdSecurityStationRailEntity> search(RdSecurityStationRailCriteria criteria) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel == null) {
            throw new UnAuthorizedTenantException();
        }
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.eq(RdSecurityStationRailEntity::isDeleted, (Object)false);
        if (!userModel.isSuperviseDepartRole()) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.in(RdSecurityStationRailEntity::getOrganizationId, (Object[])userModel.getNoSuperviseScopePermissions());
        } else if (criteria.getSearchModel() != RdSecurityStationRailCriteria.SearchModel.SecurityResource) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.in(RdSecurityStationRailEntity::getSuperviseDepartId, (Object[])userModel.getAssignedSuperviseDepartIds());
        }
        switch (criteria.getSearchModel()) {
            case Search: {
                if (!StringUtils.hasLength((String)criteria.getKeyWord())) break;
                lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.likeRight(RdSecurityStationRailEntity::getName, (Object)criteria.getKeyWord());
                break;
            }
            case SecurityResource: {
                Collection selectedDepartIds = userModel.getMatchedSuperviseDepartIds(criteria.getSuperviseDepartIds());
                if (CollectionUtils.isEmpty((Collection)selectedDepartIds)) break;
                lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.in(RdSecurityStationRailEntity::getSuperviseDepartId, selectedDepartIds);
                break;
            }
            case Station: {
                if (!StringUtils.hasLength((String)criteria.getStationId())) break;
                lambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(RdSecurityStationRailEntity::getReferenceNumber, (Object)criteria.getStationId())).eq(RdSecurityStationRailEntity::getBusinessType, (Object)RailBusinessType.Station.ordinal());
            }
        }
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.orderByDesc(RdSecurityStationRailEntity::getLastUpdatedTime);
        List data = this.securityStationRailMapper.selectList((Wrapper)lambdaQueryWrapper);
        return data;
    }

    public Collection<RdSecurityStationRailEntity> getValidRails(Collection<String> stationIds) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.in(RdSecurityStationRailEntity::getReferenceNumber, stationIds)).eq(RdSecurityStationRailEntity::getBusinessType, (Object)RailBusinessType.Station);
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.eq(RdSecurityStationRailEntity::isDeleted, (Object)false);
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.le(RdSecurityStationRailEntity::getBeginTime, (Object)DateUtils.getToday());
        lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.ge(RdSecurityStationRailEntity::getEndTime, (Object)DateUtils.getToday());
        return this.securityStationRailMapper.selectList((Wrapper)lambdaQueryWrapper);
    }
}

