package com.bcxin.backend.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * description: 背筛日志表
 * author: linchunpeng
 * date:  2023-07-12 18:17
 */
@Data
@TableName("bg_screening_user_exec_logs")
public class BgScreeningUserExecLog {

    private static final long serialVersionUID = 1L;

    @TableId(value = "pkId")
    private Long pkId;

    @TableField(value = "bg_user_id")
    private Long bgUserId;

    //类型：1 实名认证,2 背景筛查
    @TableField(value = "type")
    private Integer type;

    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @TableField(value = "created_time")
    private Date createdTime;

    //身份证号
    @TableField(value = "idnum")
    private String idnum;

    //结果
    @TableField(value = "short_result")
    private String shortResult;

    //报文
    @TableField(value = "result")
    private String result;

    //问题类型（0正常 1在逃，2吸毒，3重点，4重要信息有误）
    @TableField(value = "question_type")
    private Integer questionType;


}
