package com.bcxin.backend.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.backend.dao.mapper.BgScreeningUserMapper;
import com.bcxin.backend.entity.BgScreeningUser;
import com.bcxin.backend.service.BgScreeningUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * description: 背筛用户表service
 * author: linchunpeng
 * date:  2023-07-13 14:30
 */
@Slf4j
@Service
public class BgScreeningUserServiceImpl extends ServiceImpl<BgScreeningUserMapper, BgScreeningUser> implements BgScreeningUserService {


    /**
     * description: 查询新入职员工
     * author: linchunpeng
     * date:  2023-07-14 10:13
     */
    @Override
    public List<BgScreeningUser> findNewRecruitUser(int count) {
        IPage<BgScreeningUser> pageParam = new Page<>(1,count);
        QueryWrapper<BgScreeningUser> queryWrapper = new QueryWrapper<>();
        queryWrapper.isNotNull("idnum");//身份证不为空
        queryWrapper.eq("enabled", 1);//背筛标志位1
        queryWrapper.isNull("last_background_screening_time");//最近背筛时间为空

        IPage<BgScreeningUser> page = this.page(pageParam, queryWrapper);
        return page.getRecords();
    }

    /**
     * description: 查询定期背筛员工
     * author: linchunpeng
     * date:  2023-07-14 10:13
     */
    @Override
    public List<BgScreeningUser> findIntervalsUser(int day, int count) {
        IPage<BgScreeningUser> pageParam = new Page<>(1, count);
        QueryWrapper<BgScreeningUser> queryWrapper = new QueryWrapper<>();
        queryWrapper.isNotNull("idnum");//身份证不为空
        queryWrapper.eq("enabled", 1);//背筛标志位1
        //背筛时间大于的用户
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) - day);
        queryWrapper.le("last_background_screening_time", calendar.getTime());

        IPage<BgScreeningUser> page = this.page(pageParam, queryWrapper);
        return page.getRecords();
    }

    /**
     * description：根据身份证列表，查询背筛用户
     * author：linchunpeng
     * date：2023/7/17
     */
    @Override
    public List<BgScreeningUser> findByIdnumList(List<String> idnumList) {
        QueryWrapper<BgScreeningUser> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("idnum", idnumList);//身份证列表
        return this.list(queryWrapper);
    }
}
